/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.lexiconfig;

import com.codinglitch.lexiconfig.annotations.LexiconLibrary;
import com.codinglitch.lexiconfig.classes.LexiconData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class Library {
    public List<LexiconData> LEXICONS = new ArrayList<LexiconData>();

    public String getName() {
        LexiconLibrary annotation = this.getClass().getAnnotation(LexiconLibrary.class);
        return annotation.name();
    }

    public abstract void shelveLexicons();

    public void shelve(LexiconData lexicon) {
        this.LEXICONS.add(lexicon);
    }

    public Optional<LexiconData> browse(String name) {
        for (LexiconData lexicon : this.LEXICONS) {
            if (!name.equals(lexicon.getName())) continue;
            return Optional.of(lexicon);
        }
        return Optional.empty();
    }
}

