/*
 * Decompiled with CFR 0.152.
 */
package cech12.woodenhopper.tileentity;

import cech12.woodenhopper.api.blockentity.WoodenHopperBlockEntities;
import cech12.woodenhopper.block.WoodenHopperItemHandler;
import cech12.woodenhopper.config.ServerConfig;
import cech12.woodenhopper.inventory.WoodenHopperContainer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class WoodenHopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    private ItemStackHandler inventory = new ItemStackHandler();
    private int transferCooldown = -1;
    private long tickedGameTime;

    public WoodenHopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)WoodenHopperBlockEntities.WOODEN_HOPPER.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = new ItemStackHandler();
        if (!this.m_59631_(nbt)) {
            this.inventory.deserializeNBT(nbt);
        }
        this.transferCooldown = nbt.m_128451_("TransferCooldown");
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            compound.m_128391_(this.inventory.serializeNBT());
        }
        compound.m_128405_("TransferCooldown", this.transferCooldown);
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    @Nonnull
    protected NonNullList<ItemStack> m_7086_() {
        return NonNullList.m_122780_((int)1, (Object)this.inventory.getStackInSlot(0));
    }

    protected void m_6520_(@Nonnull NonNullList<ItemStack> itemsIn) {
        if (itemsIn.size() == 1) {
            this.inventory.setStackInSlot(0, (ItemStack)itemsIn.get(0));
        }
    }

    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        this.m_59640_(null);
        ItemStack stack = this.inventory.extractItem(index, count, false);
        this.m_6596_();
        return stack;
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        this.m_59640_(null);
        ItemStack stack = this.inventory.getStackInSlot(index);
        this.inventory.setStackInSlot(index, ItemStack.f_41583_);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int index, @Nonnull ItemStack stack) {
        this.m_59640_(null);
        this.inventory.setStackInSlot(index, stack);
        this.m_6596_();
    }

    @Nonnull
    protected Component m_6820_() {
        return Component.m_237115_((String)"block.woodenhopper.wooden_hopper");
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WoodenHopperBlockEntity entity) {
        if (level != null && !level.f_46443_) {
            --entity.transferCooldown;
            entity.tickedGameTime = level.m_46467_();
            if (!entity.isOnTransferCooldown()) {
                entity.setTransferCooldown(0);
                entity.updateHopper(() -> WoodenHopperBlockEntity.pullItems(entity));
            }
        }
    }

    private void updateHopper(Supplier<Boolean> p_200109_1_) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !this.isOnTransferCooldown() && ((Boolean)this.m_58900_().m_61143_((Property)HopperBlock.f_54022_)).booleanValue()) {
            boolean flag = false;
            if (!this.m_7983_()) {
                flag = this.transferItemsOut();
            }
            if (WoodenHopperBlockEntity.isNotFull((IItemHandler)this.inventory)) {
                flag |= p_200109_1_.get().booleanValue();
            }
            if (flag) {
                this.setTransferCooldown((Integer)ServerConfig.WOODEN_HOPPER_COOLDOWN.get());
                this.m_6596_();
            }
        }
    }

    private static ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.m_41619_(); ++slot) {
            stack = WoodenHopperBlockEntity.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack result = stack;
        if (!destInventory.insertItem(slot, stack, true).equals(stack)) {
            WoodenHopperBlockEntity destinationHopper;
            boolean inventoryWasEmpty = WoodenHopperBlockEntity.isEmpty(destInventory);
            result = destInventory.insertItem(slot, stack, false);
            if (result.m_41613_() < stack.m_41613_() && inventoryWasEmpty && destination instanceof WoodenHopperBlockEntity && !(destinationHopper = (WoodenHopperBlockEntity)((Object)destination)).mayTransfer()) {
                int k = 0;
                if (source instanceof WoodenHopperBlockEntity && destinationHopper.getLastUpdateTime() >= ((WoodenHopperBlockEntity)source).getLastUpdateTime()) {
                    k = 1;
                }
                destinationHopper.setTransferCooldown((Integer)ServerConfig.WOODEN_HOPPER_COOLDOWN.get() - k);
            }
        }
        return result;
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandler(WoodenHopperBlockEntity hopper, Direction hopperFacing) {
        double x = hopper.m_6343_() + (double)hopperFacing.m_122429_();
        double y = hopper.m_6358_() + (double)hopperFacing.m_122430_();
        double z = hopper.m_6446_() + (double)hopperFacing.m_122431_();
        return WoodenHopperBlockEntity.getItemHandler(hopper.m_58904_(), x, y, z, hopperFacing.m_122424_());
    }

    public static Optional<Pair<IItemHandler, Object>> getItemHandler(Level level, double x, double y, double z, Direction side) {
        BlockEntity blockEntity;
        int k;
        int j;
        int i = Mth.m_14107_((double)x);
        BlockPos blockpos = new BlockPos(i, j = Mth.m_14107_((double)y), k = Mth.m_14107_((double)z));
        BlockState state = level.m_8055_(blockpos);
        if (state.m_155947_() && (blockEntity = level.m_7702_(blockpos)) != null) {
            return blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).map(capability -> ImmutablePair.of((Object)capability, (Object)blockEntity));
        }
        Block block = state.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            return Optional.of(ImmutablePair.of((Object)new SidedInvWrapper(((WorldlyContainerHolder)block).m_5840_(state, (LevelAccessor)level, blockpos), side), (Object)state));
        }
        List list = level.m_6249_((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), entity -> !(entity instanceof LivingEntity) && entity.m_6084_() && entity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).isPresent());
        if (!list.isEmpty()) {
            Entity entity2 = (Entity)list.get(level.f_46441_.m_188503_(list.size()));
            return entity2.getCapability(ForgeCapabilities.ITEM_HANDLER, side).map(capability -> ImmutablePair.of((Object)capability, (Object)entity2));
        }
        return Optional.empty();
    }

    private static boolean isNotFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.m_41619_() && stackInSlot.m_41613_() >= itemHandler.getSlotLimit(slot)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.m_41613_() <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean transferItemsOut() {
        Direction hopperFacing = (Direction)this.m_58900_().m_61143_((Property)HopperBlock.f_54021_);
        return WoodenHopperBlockEntity.getItemHandler(this, hopperFacing).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (WoodenHopperBlockEntity.isNotFull(itemHandler)) {
                for (int i = 0; i < this.m_6643_(); ++i) {
                    if (this.m_8020_(i).m_41619_()) continue;
                    ItemStack originalSlotContents = this.m_8020_(i).m_41777_();
                    ItemStack insertStack = this.m_7407_(i, 1);
                    ItemStack remainder = WoodenHopperBlockEntity.putStackInInventoryAllSlots((BlockEntity)this, destination, itemHandler, insertStack);
                    if (remainder.m_41619_()) {
                        return true;
                    }
                    this.m_6836_(i, originalSlotContents);
                }
            }
            return false;
        }).orElse(false);
    }

    public static boolean pullItems(WoodenHopperBlockEntity hopper) {
        return WoodenHopperBlockEntity.getItemHandler(hopper, Direction.UP).map(itemHandlerResult -> {
            if (((Boolean)ServerConfig.WOODEN_HOPPER_PULL_ITEMS_FROM_INVENTORIES_ENABLED.get()).booleanValue()) {
                IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack extractItem = handler.extractItem(i, 1, true);
                    if (extractItem.m_41619_()) continue;
                    for (int j = 0; j < hopper.m_6643_(); ++j) {
                        ItemStack destStack = hopper.m_8020_(j);
                        if (!hopper.m_7013_(j, extractItem) || !destStack.m_41619_() && (destStack.m_41613_() >= destStack.m_41741_() || destStack.m_41613_() >= hopper.m_6893_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                        extractItem = handler.extractItem(i, 1, false);
                        if (destStack.m_41619_()) {
                            hopper.m_6836_(j, extractItem);
                        } else {
                            destStack.m_41769_(1);
                            hopper.m_6836_(j, destStack);
                        }
                        hopper.m_6596_();
                        return true;
                    }
                }
            }
            return false;
        }).orElseGet(() -> {
            if (((Boolean)ServerConfig.WOODEN_HOPPER_PULL_ITEMS_FROM_WORLD_ENABLED.get()).booleanValue()) {
                for (ItemEntity itementity : WoodenHopperBlockEntity.getCaptureItems(hopper)) {
                    if (!WoodenHopperBlockEntity.captureItem(hopper, itementity)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public static boolean captureItem(WoodenHopperBlockEntity hopper, ItemEntity p_200114_1_) {
        boolean flag = false;
        ItemStack itemstack = p_200114_1_.m_32055_().m_41777_();
        ItemStack itemstack1 = WoodenHopperBlockEntity.putStackInInventoryAllSlots(null, (Object)hopper, (IItemHandler)hopper.inventory, itemstack);
        if (itemstack1.m_41619_()) {
            flag = true;
            p_200114_1_.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            p_200114_1_.m_32045_(itemstack1);
        }
        return flag;
    }

    public static List<ItemEntity> getCaptureItems(WoodenHopperBlockEntity p_200115_0_) {
        return p_200115_0_.m_59300_().m_83299_().stream().flatMap(p_200110_1_ -> p_200115_0_.m_58904_().m_6443_(ItemEntity.class, p_200110_1_.m_82386_(p_200115_0_.m_6343_() - 0.5, p_200115_0_.m_6358_() - 0.5, p_200115_0_.m_6446_() - 0.5), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    public double m_6343_() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    public double m_6358_() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    public double m_6446_() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > (Integer)ServerConfig.WOODEN_HOPPER_COOLDOWN.get();
    }

    public void onEntityCollision(Entity p_200113_1_) {
        if (((Boolean)ServerConfig.WOODEN_HOPPER_PULL_ITEMS_FROM_WORLD_ENABLED.get()).booleanValue() && p_200113_1_ instanceof ItemEntity) {
            BlockPos blockpos = this.m_58899_();
            if (Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)p_200113_1_.m_20191_().m_82386_((double)(-blockpos.m_123341_()), (double)(-blockpos.m_123342_()), (double)(-blockpos.m_123343_()))), (VoxelShape)this.m_59300_(), (BooleanOp)BooleanOp.f_82689_)) {
                this.updateHopper(() -> WoodenHopperBlockEntity.captureItem(this, (ItemEntity)p_200113_1_));
            }
        }
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int id, @Nonnull Inventory player) {
        return new WoodenHopperContainer(id, player, this);
    }

    @Nonnull
    protected IItemHandler createUnSidedHandler() {
        return new WoodenHopperItemHandler(this);
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }
}

