/*
 * Decompiled with CFR 0.152.
 */
package cech12.woodenhopper.block;

import cech12.woodenhopper.api.blockentity.WoodenHopperBlockEntities;
import cech12.woodenhopper.config.ServerConfig;
import cech12.woodenhopper.tileentity.WoodenHopperBlockEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class WoodenHopperBlock
extends HopperBlock {
    public WoodenHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        if (!((Boolean)ServerConfig.WOODEN_HOPPER_PULL_ITEMS_FROM_WORLD_ENABLED.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"block.woodenhopper.wooden_hopper.desc.cannotAbsorbItemsFromWorld").m_130940_(ChatFormatting.RED));
        }
        if (!((Boolean)ServerConfig.WOODEN_HOPPER_PULL_ITEMS_FROM_INVENTORIES_ENABLED.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"block.woodenhopper.wooden_hopper.desc.cannotAbsorbItemsFromInventories").m_130940_(ChatFormatting.RED));
        }
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new WoodenHopperBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> entityType) {
        return WoodenHopperBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)WoodenHopperBlockEntities.WOODEN_HOPPER.get()), WoodenHopperBlockEntity::tick);
    }

    public void m_6402_(@Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = worldIn.m_7702_(pos)) instanceof WoodenHopperBlockEntity) {
            ((WoodenHopperBlockEntity)blockEntity).m_58638_(stack.m_41786_());
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof WoodenHopperBlockEntity) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((WoodenHopperBlockEntity)blockEntity), (BlockPos)pos);
            player.m_36220_(Stats.f_12957_);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof WoodenHopperBlockEntity) {
                Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((WoodenHopperBlockEntity)blockEntity));
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public void m_7892_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof WoodenHopperBlockEntity) {
            ((WoodenHopperBlockEntity)blockEntity).onEntityCollision(entityIn);
        }
    }
}

