/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.ritual.ExecCommandRitual;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Signs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandRitualRecipe
extends RitualRecipe {
    List<String> commands;
    ResourceLocation symbol = Signs.HARMONY_SIGN.getSprite();
    int color = 0;

    private CommandRitualRecipe setSymbol(ResourceLocation symbol) {
        this.symbol = symbol;
        return this;
    }

    private CommandRitualRecipe setColor(int color) {
        this.color = color;
        return this;
    }

    public CommandRitualRecipe(ResourceLocation recipeId, List<String> commands, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, float healthRequirement) {
        super(recipeId, reagent, pedestalItems, focusItems, healthRequirement);
        this.commands = commands;
    }

    @Override
    public Ritual getRitual() {
        return new ExecCommandRitual(this.symbol, this.color, this.commands).setRegistryName(this.id);
    }

    @Override
    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon:ritual_brazier_command");
        JsonArray commandsJson = new JsonArray();
        for (String command : this.commands) {
            commandsJson.add(command);
        }
        jsonobject.add("commands", (JsonElement)commandsJson);
        jsonobject.addProperty("symbol", this.symbol.toString());
        jsonobject.addProperty("color", (Number)this.color);
        CommandRitualRecipe.addRitualElements(this, jsonobject);
        return jsonobject;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.COMMAND_RITUAL_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.COMMAND_RITUAL_TYPE.get();
    }

    public static class Serializer
    extends RitualRecipe.Serializer<CommandRitualRecipe> {
        @NotNull
        public CommandRitualRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject json) {
            Ingredient reagent = Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"reagent"));
            float healthRequirement = json.has("healthRequirement") ? GsonHelper.m_13915_((JsonObject)json, (String)"healthRequirement") : 0.0f;
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            List<Ingredient> stacks = RitualRecipe.getPedestalItems(pedestalItems);
            JsonArray focusItems = GsonHelper.m_13933_((JsonObject)json, (String)"focusItems");
            List<Ingredient> foci = RitualRecipe.getPedestalItems(focusItems);
            ArrayList<String> commands = new ArrayList<String>();
            if (json.has("commands")) {
                JsonArray commandsJson = GsonHelper.m_13933_((JsonObject)json, (String)"commands");
                for (JsonElement element : commandsJson) {
                    commands.add(element.getAsString());
                }
            } else if (json.has("command")) {
                commands.add(GsonHelper.m_13906_((JsonObject)json, (String)"command"));
            }
            ResourceLocation symbol = json.has("symbol") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"symbol")) : Signs.HARMONY_SIGN.getSprite();
            int color = GsonHelper.m_13927_((JsonObject)json, (String)"color");
            return new CommandRitualRecipe(pRecipeId, commands, reagent, stacks, foci, healthRequirement).setSymbol(symbol).setColor(color);
        }

        @Nullable
        public CommandRitualRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, @NotNull FriendlyByteBuf pBuffer) {
            int length = pBuffer.readInt();
            int length2 = pBuffer.readInt();
            Ingredient reagent = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            ArrayList<Ingredient> foci = new ArrayList<Ingredient>();
            for (int i = 0; i < length2; ++i) {
                try {
                    foci.add(Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            float healthRequirement = pBuffer.readFloat();
            int commandsLength = pBuffer.readInt();
            ArrayList<String> commands = new ArrayList<String>();
            for (int i = 0; i < commandsLength; ++i) {
                commands.add(pBuffer.m_130277_());
            }
            ResourceLocation symbol = pBuffer.m_130281_();
            int color = pBuffer.readInt();
            return new CommandRitualRecipe(pRecipeId, commands, reagent, stacks, foci, healthRequirement).setSymbol(symbol).setColor(color);
        }

        @Override
        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull CommandRitualRecipe recipe) {
            super.toNetwork(buf, recipe);
            buf.writeInt(recipe.commands.size());
            for (String command : recipe.commands) {
                buf.m_130070_(command);
            }
            buf.m_130085_(recipe.symbol);
            buf.writeInt(recipe.color);
        }
    }
}

