/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.util.ColorUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class MagicBurstEffectPacket {
    final float x;
    final float y;
    final float z;
    final int c1;
    final int c2;

    public MagicBurstEffectPacket(BlockPos pos, int color1, int color2) {
        this((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, color1, color2);
    }

    public MagicBurstEffectPacket(double x, double y, double z, int color1, int color2) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        this.c1 = color1;
        this.c2 = color2;
    }

    public static void encode(MagicBurstEffectPacket object, FriendlyByteBuf buffer) {
        buffer.writeFloat(object.x).writeFloat(object.y).writeFloat(object.z);
        buffer.writeInt(object.c1).writeInt(object.c2);
    }

    public static MagicBurstEffectPacket decode(FriendlyByteBuf buffer) {
        return new MagicBurstEffectPacket(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readInt());
    }

    public static void consume(MagicBurstEffectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Eidolon.proxy.getWorld();
            if (world != null) {
                double x = packet.x;
                double y = packet.y;
                double z = packet.z;
                float r1 = (float)ColorUtil.getRed(packet.c1) / 255.0f;
                float g1 = (float)ColorUtil.getGreen(packet.c1) / 255.0f;
                float b1 = (float)ColorUtil.getBlue(packet.c1) / 255.0f;
                float r2 = (float)ColorUtil.getRed(packet.c2) / 255.0f;
                float g2 = (float)ColorUtil.getGreen(packet.c2) / 255.0f;
                float b2 = (float)ColorUtil.getBlue(packet.c2) / 255.0f;
                Particles.create(EidolonParticles.WISP_PARTICLE).setAlpha(0.5f, 0.0f).setScale(0.25f, 0.0f).setLifetime(20).randomOffset(0.125, 0.125).randomVelocity(0.0625, 0.0625).setColor(r1, g1, b1, r2, g2, b2).repeat(world, x, y, z, 12);
                Particles.create(EidolonParticles.SPARKLE_PARTICLE).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(80).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.125).addVelocity(0.0, 0.25, 0.0).setColor(r1, g1, b1, r2, g2, b2).enableGravity().setSpin(0.4f).repeat(world, x, y, z, world.f_46441_.m_188503_(4) + 3);
                Particles.create(EidolonParticles.SMOKE_PARTICLE).setAlpha(0.25f, 0.0f).setScale(0.375f, 0.0f).setLifetime(20).randomOffset(0.25, 0.25).randomVelocity(0.015625, 0.015625).setColor(r2, g2, b2).repeat(world, x, y, z, 6);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

