/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.registries.EidolonParticles;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class FeatherEffectPacket {
    final float x;
    final float y;
    final float z;

    public FeatherEffectPacket(BlockPos pos) {
        this((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public FeatherEffectPacket(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public static void encode(FeatherEffectPacket object, FriendlyByteBuf buffer) {
        buffer.writeFloat(object.x).writeFloat(object.y).writeFloat(object.z);
    }

    public static FeatherEffectPacket decode(FriendlyByteBuf buffer) {
        return new FeatherEffectPacket(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public static void consume(FeatherEffectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Eidolon.proxy.getWorld();
            if (world != null) {
                double x = packet.x;
                double y = (double)packet.y + 0.5;
                double z = packet.z;
                Particles.create(EidolonParticles.FEATHER_PARTICLE).setAlpha(0.5f, 0.0f).setScale(0.5f, 0.0f).setLifetime(20).randomOffset(0.125, 0.125).randomVelocity(0.0625).setColor(0.2f, 0.2f, 0.7f).repeat(world, x, y, z, 6);
                Particles.create(EidolonParticles.FEATHER_PARTICLE).setAlpha(0.25f, 0.0f).setScale(0.5f, 0.0f).setLifetime(10).randomOffset(0.125, 0.125).randomVelocity(0.0625).setColor(0.3f, 0.3f, 0.7f).repeat(world, x + 0.5, y, z + 0.5, 6);
                Particles.create(EidolonParticles.FEATHER_PARTICLE).setAlpha(0.5f, 0.0f).setScale(0.5f, 0.0f).setLifetime(10).randomOffset(0.125, 0.125).randomVelocity(0.0625).setColor(0.3f, 0.3f, 0.7f).repeat(world, x - 0.5, y, z - 0.5, 6);
                Particles.create(EidolonParticles.SPARKLE_PARTICLE).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(80).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.125).addVelocity(0.0, 0.25, 0.0).setColor(0.2f, 0.2f, 0.7f).enableGravity().setSpin(0.4f).repeat(world, x, y, z, world.f_46441_.m_188503_(4) + 3);
                Particles.create(EidolonParticles.SMOKE_PARTICLE).setAlpha(0.25f, 0.0f).setScale(0.375f, 0.0f).setLifetime(20).randomOffset(0.25, 0.25).randomVelocity(0.015625, 0.015625).setColor(0.2f, 0.2f, 0.7f).repeat(world, x, y, z, 6);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

