/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.registries.EidolonParticles;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class CrucibleSuccessPacket {
    final BlockPos pos;
    final float r;
    final float g;
    final float b;

    public CrucibleSuccessPacket(BlockPos pos, float r, float g, float b) {
        this.pos = pos;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static void encode(CrucibleSuccessPacket object, FriendlyByteBuf buffer) {
        buffer.m_130064_(object.pos);
        buffer.writeFloat(object.r).writeFloat(object.g).writeFloat(object.b);
    }

    public static CrucibleSuccessPacket decode(FriendlyByteBuf buffer) {
        return new CrucibleSuccessPacket(buffer.m_130135_(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public static void consume(CrucibleSuccessPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Eidolon.proxy.getWorld();
            if (world != null) {
                BlockPos pos = packet.pos;
                double x = (double)pos.m_123341_() + 0.5;
                double y = pos.m_123342_() + 1;
                double z = (double)pos.m_123343_() + 0.5;
                world.m_6263_(Eidolon.proxy.getPlayer(), x, y, z, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 0.75f);
                world.m_6263_(Eidolon.proxy.getPlayer(), x, y, z, SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 0.75f);
                Particles.create(EidolonParticles.STEAM_PARTICLE).setAlpha(0.0625f, 0.0f).setScale(0.375f, 0.125f).setLifetime(40).randomOffset(0.375, 0.125).randomVelocity(0.025f, 0.0125f).addVelocity(0.0, 0.0125f, 0.0).setColor(packet.r, packet.g, packet.b).repeat(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, 20);
                Particles.create(EidolonParticles.SPARKLE_PARTICLE).setAlpha(0.0625f, 0.0f).setScale(0.125f, 0.0f).setLifetime(80).randomOffset(0.375, 0.375).randomVelocity(0.00625f, 0.00625f).addVelocity(0.0, 0.0, 0.0).setColor(packet.r, packet.g, packet.b).setSpin(0.1f).repeat(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.25, (double)pos.m_123343_() + 0.5, 8);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

