/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import com.google.gson.JsonElement;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.datagen.SimpleDataProvider;
import elucent.eidolon.recipe.ChantRecipe;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.registries.Spells;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import org.jetbrains.annotations.NotNull;

public class EidChantProvider
extends SimpleDataProvider {
    List<ChantRecipe> chants = new ArrayList<ChantRecipe>();

    public EidChantProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addChants();
        for (ChantRecipe recipe : this.chants) {
            Path path = EidChantProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, (JsonElement)recipe.toJson(), path);
        }
    }

    protected void addChants() {
        Spells.init();
        this.addChant(Spells.DARK_PRAYER, Signs.WICKED_SIGN, Signs.WICKED_SIGN, Signs.WICKED_SIGN);
        this.addChant(Spells.DARK_ANIMAL_SACRIFICE, Signs.WICKED_SIGN, Signs.BLOOD_SIGN, Signs.WICKED_SIGN);
        this.addChant(Spells.DARK_TOUCH, Signs.WICKED_SIGN, Signs.SOUL_SIGN, Signs.WICKED_SIGN, Signs.SOUL_SIGN);
        this.addChant(Spells.DARKLIGHT_CHANT, Signs.WICKED_SIGN, Signs.FLAME_SIGN, Signs.WICKED_SIGN, Signs.FLAME_SIGN);
        this.addChant(Spells.DARK_VILLAGER_SACRIFICE, Signs.BLOOD_SIGN, Signs.WICKED_SIGN, Signs.BLOOD_SIGN, Signs.SOUL_SIGN);
        this.addChant(Spells.ZOMBIFY, Signs.DEATH_SIGN, Signs.BLOOD_SIGN, Signs.WICKED_SIGN, Signs.DEATH_SIGN, Signs.SOUL_SIGN, Signs.BLOOD_SIGN);
        this.addChant(Spells.ENTHRALL_UNDEAD, Signs.WICKED_SIGN, Signs.MIND_SIGN, Signs.MAGIC_SIGN, Signs.MAGIC_SIGN, Signs.MIND_SIGN);
        this.addChant(Spells.LIGHT_PRAYER, Signs.SACRED_SIGN, Signs.SACRED_SIGN, Signs.SACRED_SIGN);
        this.addChant(Spells.LIGHT_CHANT, Signs.SACRED_SIGN, Signs.FLAME_SIGN, Signs.SACRED_SIGN, Signs.FLAME_SIGN);
        this.addChant(Spells.HOLY_TOUCH, Signs.SACRED_SIGN, Signs.SOUL_SIGN, Signs.SACRED_SIGN, Signs.SOUL_SIGN);
        this.addChant(Spells.LAY_ON_HANDS, Signs.FLAME_SIGN, Signs.SOUL_SIGN, Signs.SACRED_SIGN, Signs.SOUL_SIGN, Signs.SACRED_SIGN);
        this.addChant(Spells.CURE_ZOMBIE_CHANT, Signs.SACRED_SIGN, Signs.SOUL_SIGN, Signs.MIND_SIGN, Signs.HARMONY_SIGN, Signs.FLAME_SIGN, Signs.SOUL_SIGN);
        this.addChant(Spells.SMITE_CHANT, Signs.FLAME_SIGN, Signs.MAGIC_SIGN, Signs.SACRED_SIGN, Signs.DEATH_SIGN, Signs.MAGIC_SIGN, Signs.SACRED_SIGN);
        this.addChant(Spells.SUNDER_ARMOR, Signs.FLAME_SIGN, Signs.MAGIC_SIGN, Signs.WICKED_SIGN, Signs.MAGIC_SIGN, Signs.FLAME_SIGN);
        this.addChant(Spells.BLESS_ARMOR, Signs.SACRED_SIGN, Signs.WARDING_SIGN, Signs.SACRED_SIGN, Signs.WARDING_SIGN, Signs.SACRED_SIGN);
        this.addChant(Spells.FROST_CHANT, Signs.WICKED_SIGN, Signs.WINTER_SIGN, Signs.BLOOD_SIGN, Signs.WINTER_SIGN, Signs.WICKED_SIGN);
        this.addChant(Spells.FIRE_CHANT, Signs.FLAME_SIGN, Signs.FLAME_SIGN, Signs.FLAME_SIGN);
        this.addChant(Spells.WATER_CHANT, Signs.WINTER_SIGN, Signs.WINTER_SIGN, Signs.FLAME_SIGN, Signs.FLAME_SIGN);
    }

    private void addChant(Spell spell, Sign ... signs) {
        this.chants.add(new ChantRecipe(spell.getRegistryName(), List.of(signs)));
    }

    @NotNull
    public String m_6055_() {
        return "Eidolon Chants";
    }

    protected static Path getRecipePath(Path pathIn, Spell spell) {
        return EidChantProvider.getRecipePath(pathIn, spell.getRegistryName().m_135815_());
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/eidolon/recipes/" + str + ".json");
    }
}

