/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.common.block.WoodenStandBlock;
import elucent.eidolon.common.tile.CrucibleTileEntity;
import elucent.eidolon.gui.WoodenBrewingStandContainer;
import elucent.eidolon.registries.Registry;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class WoodenStandTileEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] OUTPUT_SLOTS = new int[]{0, 1, 2};
    private NonNullList<ItemStack> brewingItemStacks = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int brewTime;
    private int heat;
    private boolean[] filledSlots;
    private Item ingredientID;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> WoodenStandTileEntity.this.brewTime;
                case 1 -> WoodenStandTileEntity.this.heat;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    WoodenStandTileEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    WoodenStandTileEntity.this.heat = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public WoodenStandTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.WOODEN_STAND_TILE_ENTITY.get(), pos, state);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.eidolon.wooden_brewing_stand");
    }

    public int m_6643_() {
        return this.brewingItemStacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.brewingItemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        boolean[] aboolean;
        BlockEntity below;
        boolean flag = this.canBrew();
        boolean flag1 = this.brewTime > 0;
        ItemStack itemstack1 = (ItemStack)this.brewingItemStacks.get(3);
        if (this.f_58857_ != null && this.f_58857_.m_46467_() % 20L == 0L && (below = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) instanceof CrucibleTileEntity) {
            CrucibleTileEntity crucibleTileEntity = (CrucibleTileEntity)below;
            int prevHeat = this.heat;
            int n = this.heat = crucibleTileEntity.boiling ? 1 : 0;
            if (prevHeat != this.heat) {
                this.m_6596_();
            }
        }
        if (flag1) {
            boolean flag2;
            --this.brewTime;
            boolean bl = flag2 = this.brewTime == 0;
            if (flag2 && flag) {
                this.brewPotions();
                this.m_6596_();
            } else if (!flag || this.heat == 0) {
                this.brewTime = 0;
                this.m_6596_();
            } else if (this.ingredientID != itemstack1.m_41720_()) {
                this.brewTime = 0;
                this.m_6596_();
            }
        } else if (flag && this.heat > 0) {
            this.brewTime = 800;
            this.ingredientID = itemstack1.m_41720_();
            this.m_6596_();
        }
        if (!this.f_58857_.f_46443_ && !Arrays.equals(aboolean = this.createFilledSlotsArray(), this.filledSlots)) {
            this.filledSlots = aboolean;
            BlockState blockstate = this.f_58857_.m_8055_(this.m_58899_());
            if (!(blockstate.m_60734_() instanceof WoodenStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.f_50905_.length; ++i) {
                blockstate = (BlockState)blockstate.m_61124_((Property)BrewingStandBlock.f_50905_[i], (Comparable)Boolean.valueOf(aboolean[i]));
            }
            this.f_58857_.m_7731_(this.f_58858_, blockstate, 2);
        }
    }

    public boolean[] createFilledSlotsArray() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.brewingItemStacks.get(i)).m_41619_()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private boolean canBrew() {
        ItemStack itemstack = (ItemStack)this.brewingItemStacks.get(3);
        if (!itemstack.m_41619_()) {
            return BrewingRecipeRegistry.canBrew(this.brewingItemStacks, (ItemStack)itemstack, (int[])OUTPUT_SLOTS);
        }
        if (itemstack.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = (ItemStack)this.brewingItemStacks.get(i);
            if (itemstack1.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    private void brewPotions() {
        if (this.f_58857_ == null || ForgeEventFactory.onPotionAttemptBrew(this.brewingItemStacks)) {
            return;
        }
        ItemStack itemstack = (ItemStack)this.brewingItemStacks.get(3);
        BrewingRecipeRegistry.brewPotions(this.brewingItemStacks, (ItemStack)itemstack, (int[])OUTPUT_SLOTS);
        ForgeEventFactory.onPotionBrewed(this.brewingItemStacks);
        BlockPos blockpos = this.m_58899_();
        if (itemstack.hasCraftingRemainingItem()) {
            ItemStack itemstack1 = itemstack.getCraftingRemainingItem();
            itemstack.m_41774_(1);
            if (itemstack.m_41619_()) {
                itemstack = itemstack1;
            } else if (!this.f_58857_.f_46443_) {
                Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)itemstack1);
            }
        } else {
            itemstack.m_41774_(1);
        }
        this.brewingItemStacks.set(3, (Object)itemstack);
        this.f_58857_.m_46796_(1035, blockpos, 0);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.brewingItemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.brewingItemStacks);
        this.brewTime = nbt.m_128448_("BrewTime");
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128376_("BrewTime", (short)this.brewTime);
        ContainerHelper.m_18973_((CompoundTag)compound, this.brewingItemStacks);
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.brewingItemStacks.size() ? (ItemStack)this.brewingItemStacks.get(index) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.brewingItemStacks, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.brewingItemStacks, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        if (index >= 0 && index < this.brewingItemStacks.size()) {
            this.brewingItemStacks.set(index, (Object)stack);
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        if (index == 3) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack) && !stack.m_204117_(Tags.Items.DUSTS_REDSTONE) && !stack.m_204117_(Tags.Items.DUSTS_GLOWSTONE);
        }
        return BrewingRecipeRegistry.isValidInput((ItemStack)stack) && this.m_8020_(index).m_41619_();
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        if (side == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : OUTPUT_SLOTS;
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (index == 3) {
            return stack.m_41720_() == Items.f_42590_;
        }
        return true;
    }

    public void m_6211_() {
        this.brewingItemStacks.clear();
    }

    @NotNull
    public AbstractContainerMenu m_6555_(int id, @NotNull Inventory player) {
        return new WoodenBrewingStandContainer(id, player, (Container)this, this.dataAccess);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

