/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.Config;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.tile.TileEntityBase;
import elucent.eidolon.network.CrucibleFailPacket;
import elucent.eidolon.network.CrucibleSuccessPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.recipe.CrucibleRecipe;
import elucent.eidolon.recipe.CrucibleRegistry;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrucibleTileEntity
extends TileEntityBase {
    boolean boiling = false;
    public boolean hasWater = false;
    int stirTicks = 0;
    int stirs = 0;
    int stepCounter = 0;
    final List<CrucibleStep> steps = new ArrayList<CrucibleStep>();
    long seed = 0L;
    final Random random = new Random();
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    public FluidTank tank = new FluidTank(1000){

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().m_6212_((Fluid)Fluids.f_76193_);
        }

        public void onContentsChanged() {
            super.onContentsChanged();
            if (CrucibleTileEntity.this.f_58857_ != null) {
                boolean bl = CrucibleTileEntity.this.hasWater = this.getFluid().getAmount() == 1000;
                if (!((CrucibleTileEntity)CrucibleTileEntity.this).f_58857_.f_46443_) {
                    CrucibleTileEntity.this.sync();
                }
            }
        }
    };
    public static final List<Predicate<BlockState>> HOT_BLOCKS = new ArrayList<Predicate<BlockState>>(List.of(b -> b.m_204336_(Registry.CRUCIBLE_HOT_BLOCKS), b -> b.m_60734_() instanceof CampfireBlock && b.m_61138_((Property)CampfireBlock.f_51227_) && (Boolean)b.m_61143_((Property)CampfireBlock.f_51227_) != false));

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.FLUID_HANDLER ? this.holder.cast() : super.getCapability(capability, facing);
    }

    public float getRed() {
        this.random.setSeed(this.seed);
        return this.random.nextFloat();
    }

    public float getGreen() {
        this.random.setSeed(this.seed * 2L);
        return this.random.nextFloat();
    }

    public float getBlue() {
        this.random.setSeed(this.seed * 3L);
        return this.random.nextFloat();
    }

    public void fill() {
        this.tank.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
    }

    private void drain() {
        this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
    }

    public CrucibleTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.CRUCIBLE_TILE_ENTITY.get(), pos, state);
    }

    public CrucibleTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public InteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.f_58857_ != null) {
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank)) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && player.m_21120_(hand).m_41619_() && this.hasWater) {
                this.boiling = false;
                this.stirs = 0;
                this.steps.clear();
                if (!this.f_58857_.f_46443_) {
                    this.drain();
                    this.f_58857_.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(hand).m_41619_() && this.stirTicks == 0 && !this.steps.isEmpty()) {
                ++this.stirs;
                this.stirTicks = 20;
                if (!this.f_58857_.f_46443_) {
                    this.f_58857_.m_5594_(null, pos, SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.sync();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.steps.clear();
        ListTag steps = tag.m_128437_("steps", 10);
        for (Tag step : steps) {
            this.steps.add(new CrucibleStep((CompoundTag)step));
        }
        this.boiling = tag.m_128471_("boiling");
        this.tank.readFromNBT(tag);
        this.hasWater = this.tank.getFluidAmount() == 1000;
        this.stirs = tag.m_128451_("stirs");
        this.stirTicks = tag.m_128451_("stirTicks");
        this.seed = steps.stream().map(Object::hashCode).reduce(0, (a, b) -> a ^ b).intValue();
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        ListTag steps = new ListTag();
        for (CrucibleStep step : this.steps) {
            steps.add((Object)step.write());
        }
        tag.m_128365_("steps", (Tag)steps);
        tag.m_128379_("boiling", this.boiling);
        tag.m_128405_("stirs", this.stirs);
        tag.m_128405_("stirTicks", this.stirTicks);
        if (!this.tank.isEmpty()) {
            this.tank.writeToNBT(tag);
        }
    }

    public void tick() {
        List items;
        float steamB;
        boolean stepSize;
        if (this.stirTicks > 0) {
            --this.stirTicks;
        }
        if (this.f_58857_ == null) {
            return;
        }
        if (this.hasWater && this.f_58857_.m_46467_() % 200L == 0L) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
            boolean isHeated = false;
            for (Predicate<BlockState> pred : HOT_BLOCKS) {
                if (!pred.test(state)) continue;
                isHeated = true;
                break;
            }
            if (this.boiling && !isHeated) {
                this.boiling = false;
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
            } else if (!this.boiling && isHeated) {
                this.boiling = true;
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
            }
        }
        float bubbleR = !(stepSize = this.steps.isEmpty()) ? Math.min(1.0f, this.getRed() * 1.25f) : 0.25f;
        float bubbleG = !stepSize ? Math.min(1.0f, this.getGreen() * 1.25f) : 0.5f;
        float bubbleB = !stepSize ? Math.min(1.0f, this.getBlue() * 1.25f) : 1.0f;
        float steamR = !stepSize ? Math.min(1.0f, 1.0f - (float)Math.pow(1.0f - this.getRed(), 2.0)) : 1.0f;
        float steamG = !stepSize ? Math.min(1.0f, 1.0f - (float)Math.pow(1.0f - this.getGreen(), 2.0)) : 1.0f;
        float f = steamB = !stepSize ? Math.min(1.0f, 1.0f - (float)Math.pow(1.0f - this.getBlue(), 2.0)) : 1.0f;
        if (this.f_58857_.f_46443_ && this.hasWater && this.boiling) {
            for (int i = 0; i < 2; ++i) {
                Particles.create(EidolonParticles.BUBBLE_PARTICLE).setScale(0.05f).setLifetime(10).addVelocity(0.0, 0.015625, 0.0).setColor(bubbleR, bubbleG, bubbleB).setAlpha(1.0f, 0.75f).spawn(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.125 + 0.75 * (double)this.f_58857_.f_46441_.m_188501_(), (double)this.f_58858_.m_123342_() + 0.6875, (double)this.f_58858_.m_123343_() + 0.125 + 0.75 * (double)this.f_58857_.f_46441_.m_188501_());
                if (this.f_58857_.f_46441_.m_188503_(8) != 0) continue;
                Particles.create(EidolonParticles.STEAM_PARTICLE).setAlpha(0.0625f, 0.0f).setScale(0.375f, 0.125f).setLifetime(80).randomOffset(0.375, 0.125).randomVelocity(0.0125f, 0.025f).addVelocity(0.0, 0.05f, 0.0).setColor(steamR, steamG, steamB).spawn(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.625, (double)this.f_58858_.m_123343_() + 0.5);
            }
        }
        if (!this.f_58857_.f_46443_ && this.boiling && this.hasWater && this.f_58857_.m_46467_() % 8L == 0L) {
            List items2 = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82406_(0.125));
            for (ItemEntity item : items2) {
                item.m_32010_(20);
            }
        }
        if (!this.f_58857_.f_46443_ && this.stepCounter > 0 && --this.stepCounter == 0) {
            if (((Boolean)Config.TURN_BASED_CRUCIBLE.get()).booleanValue()) {
                this.handleTurnBasedUpdate(steamR, steamG, steamB);
            } else {
                this.handleTimedUpdate(steamR, steamG, steamB);
            }
        }
        if (this.stepCounter == 0 && (stepSize || ((Boolean)Config.TURN_BASED_CRUCIBLE.get()).booleanValue()) && this.hasWater && this.boiling && this.f_58857_.m_46467_() % 100L == 0L && !(items = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82406_(0.125))).isEmpty()) {
            this.stepCounter = (Integer)Config.CRUCIBLE_STEP_DURATION.get() / 2;
        }
    }

    private void handleTurnBasedUpdate(float steamR, float steamG, float steamB) {
        List<ItemStack> contents = this.tryConsumeItems();
        if (this.stirs == 0 && contents.isEmpty()) {
            this.stepCounter = (Integer)Config.CRUCIBLE_STEP_BACKOFF.get();
            return;
        }
        CrucibleStep step = new CrucibleStep(this.stirs, contents);
        this.stirs = 0;
        if (!CrucibleRegistry.doStepsHaveSomeResult(this.steps)) {
            Networking.sendToTracking(this.f_58857_, this.f_58858_, new CrucibleFailPacket(this.f_58858_));
            this.steps.clear();
            this.boiling = false;
            this.drain();
            return;
        }
        this.steps.add(step);
        CrucibleRecipe recipe = CrucibleRegistry.find(this.steps);
        if (recipe != null) {
            this.completeCraft(steamR, steamG, steamB, contents, recipe);
        } else {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.stepCounter = (Integer)Config.CRUCIBLE_STEP_DURATION.get();
            this.sync();
        }
    }

    private List<ItemStack> tryConsumeItems() {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82406_(0.125));
        for (ItemEntity item : items) {
            for (int i = 0; i < item.m_32055_().m_41613_(); ++i) {
                ItemStack stack = item.m_32055_().m_41777_();
                stack.m_41764_(1);
                contents.add(stack);
            }
            item.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return contents;
    }

    private void handleTimedUpdate(float steamR, float steamG, float steamB) {
        List<ItemStack> contents = this.tryConsumeItems();
        if (this.stirs == 0 && contents.isEmpty()) {
            Networking.sendToTracking(this.f_58857_, this.f_58858_, new CrucibleFailPacket(this.f_58858_));
            this.steps.clear();
            this.stirs = 0;
            this.boiling = false;
            this.drain();
        } else {
            CrucibleStep step = new CrucibleStep(this.stirs, contents);
            this.steps.add(step);
            this.stirs = 0;
            CrucibleRecipe recipe = CrucibleRegistry.find(this.steps);
            if (recipe != null) {
                this.completeCraft(steamR, steamG, steamB, contents, recipe);
            } else {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.stepCounter = (Integer)Config.CRUCIBLE_STEP_DURATION.get();
                this.sync();
            }
        }
    }

    private void completeCraft(float steamR, float steamG, float steamB, List<ItemStack> contents, CrucibleRecipe recipe) {
        Networking.sendToTracking(this.f_58857_, this.f_58858_, new CrucibleSuccessPacket(this.f_58858_, steamR, steamG, steamB));
        double angle = this.f_58857_.f_46441_.m_188500_() * Math.PI * 2.0;
        ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.75, (double)this.f_58858_.m_123343_() + 0.5, recipe.getResult().m_41777_());
        entity.m_20334_(Math.sin(angle) * 0.125, 0.25, Math.cos(angle) * 0.125);
        entity.m_32010_(10);
        this.f_58857_.m_7967_((Entity)entity);
        contents.clear();
        this.steps.clear();
        this.boiling = false;
        this.drain();
    }

    public static class CrucibleStep {
        final int stirs;
        final List<ItemStack> contents = new ArrayList<ItemStack>();

        public CrucibleStep(int stirs, List<ItemStack> contents) {
            this.stirs = stirs;
            this.contents.addAll(contents);
        }

        public int getStirs() {
            return this.stirs;
        }

        public List<ItemStack> getContents() {
            return this.contents;
        }

        public CrucibleStep(CompoundTag nbt) {
            this.stirs = nbt.m_128451_("stirs");
            ListTag list = nbt.m_128437_("contents", 10);
            for (Tag item : list) {
                this.contents.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)item)));
            }
        }

        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("stirs", this.stirs);
            ListTag list = new ListTag();
            for (ItemStack stack : this.contents) {
                list.add((Object)stack.m_41739_(new CompoundTag()));
            }
            nbt.m_128365_("contents", (Tag)list);
            return nbt;
        }
    }
}

