/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import elucent.eidolon.common.item.curio.EidolonCurio;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.util.TargetMode;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class AngelSightItem
extends EidolonCurio {
    public AngelSightItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(AngelSightItem::addMode);
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return !slotContext.entity().m_6144_();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (pPlayer.m_6144_() && !pLevel.f_46443_) {
            ItemStack stack = pPlayer.m_21120_(pUsedHand);
            CompoundTag tag = stack.m_41784_();
            int mode = tag.m_128451_("mode");
            mode = (mode + 1) % 3;
            tag.m_128405_("mode", mode);
            stack.m_41751_(tag);
            pPlayer.m_213846_((Component)Component.m_237115_((String)("eidolon.angels_sight.mode." + mode)));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        String modeTooltip = switch (stack.m_41784_().m_128451_("mode")) {
            case 1 -> "lore.eidolon.angels_sight.mode.1";
            case 2 -> "lore.eidolon.angels_sight.mode.2";
            default -> "lore.eidolon.angels_sight.mode.3";
        };
        tooltip.add((Component)Component.m_237115_((String)modeTooltip).m_130940_(ChatFormatting.DARK_GRAY));
    }

    @SubscribeEvent
    public static void addMode(EntityJoinLevelEvent event) {
        Projectile projectile;
        Entity entity = event.getEntity();
        if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).m_19749_()) instanceof Player) {
            Player player = (Player)entity;
            CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)Registry.ANGELS_SIGHT.get()).ifPresent(ring -> {
                Predicate<Entity> targetMode;
                switch (ring.stack().m_41784_().m_128451_("mode")) {
                    case 1: {
                        Predicate<Entity> predicate = target -> target instanceof LivingEntity && !(target instanceof Player);
                        break;
                    }
                    case 2: {
                        Predicate<Entity> predicate = target -> target instanceof Enemy;
                        break;
                    }
                    default: {
                        Predicate<Entity> predicate = targetMode = target -> target instanceof LivingEntity;
                    }
                }
                if (projectile instanceof TargetMode) {
                    TargetMode mode = (TargetMode)projectile;
                    mode.eidolonrepraised$setMode(targetMode);
                }
            });
        }
    }
}

