/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import elucent.eidolon.capability.SoulImpl;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.SoulUpdatePacket;
import elucent.eidolon.registries.EidolonAttributes;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public interface ISoul {
    public static final Capability<ISoul> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISoul>(){});

    public boolean hasEtherealHealth();

    public float getMaxEtherealHealth();

    public float getEtherealHealth();

    public void setEtherealHealth(float var1);

    public void setMaxEtherealHealth(float var1);

    default public float hurtEtherealHealth(float amount, float persistentHealth) {
        amount = Math.max(0.0f, amount);
        float oldHealth = this.getEtherealHealth();
        this.setMaxEtherealHealth(Math.max(this.getMaxEtherealHealth() - amount, Math.min(persistentHealth, this.getMaxEtherealHealth())));
        this.setEtherealHealth(oldHealth - amount);
        return Math.max(0.0f, amount - oldHealth);
    }

    default public void healEtherealHealth(float amount, float persistentHealth) {
        amount = Math.max(0.0f, amount);
        this.setEtherealHealth(Math.min(Math.max(this.getEtherealHealth(), persistentHealth), this.getEtherealHealth() + amount));
    }

    public boolean hasMagic();

    public float getMaxMagic();

    public float getMagic();

    public void setMagic(float var1);

    public void setMaxMagic(float var1);

    default public void takeMagic(float amount) {
        amount = Math.max(0.0f, amount);
        this.setMagic(this.getMagic() - amount);
    }

    default public void giveMagic(float amount) {
        amount = Math.max(0.0f, amount);
        this.setMagic(this.getMagic() + amount);
    }

    public static float getPersistentHealth(LivingEntity entity) {
        AttributeInstance attr = entity.m_21051_((Attribute)EidolonAttributes.PERSISTENT_SOUL_HEARTS.get());
        if (attr != null) {
            return (float)attr.m_22135_();
        }
        return 0.0f;
    }

    public static void expendMana(Player player, int amount) {
        if (player.m_7500_()) {
            return;
        }
        player.getCapability(INSTANCE).ifPresent(soul -> {
            if (soul.getMagic() >= (float)amount) {
                soul.takeMagic(amount);
            }
            if (!player.f_19853_.f_46443_) {
                Networking.sendToTracking(player.f_19853_, player.m_20097_(), new SoulUpdatePacket(player));
            }
        });
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        final SoulImpl impl = new SoulImpl();

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            if (cap == INSTANCE) {
                return LazyOptional.of(() -> this.impl);
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.deserializeNBT(nbt);
        }
    }
}

