/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import elucent.eidolon.capability.PlayerDataImpl;
import elucent.eidolon.common.item.IWingsItem;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public interface IPlayerData {
    public static final Capability<IPlayerData> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerData>(){});

    default public ItemStack getWingsItem(Player player) {
        ItemStack[] result = new ItemStack[]{ItemStack.f_41583_};
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                ItemStack s = h.getStackInSlot(i);
                if (!(s.m_41720_() instanceof IWingsItem)) continue;
                result[0] = s;
                break;
            }
        });
        return result[0];
    }

    default public int getMaxWingCharges(Player player) {
        ItemStack wings = this.getWingsItem(player);
        Item item = wings.m_41720_();
        if (item instanceof IWingsItem) {
            IWingsItem i = (IWingsItem)item;
            return i.getMaxCharges(wings);
        }
        return 0;
    }

    default public boolean isDashing(Player player) {
        return this.getDashTicks(player) > 0;
    }

    default public boolean canFlap(Player player) {
        return !player.m_20096_() && !player.f_146808_ && !player.m_6069_() && !player.m_20159_() && !player.m_150110_().f_35935_;
    }

    public int getDashTicks(Player var1);

    public void doDashTick(Player var1);

    public boolean tryDash(Player var1);

    public int getWingCharges(Player var1);

    public void rechargeWings(Player var1);

    public boolean tryFlapWings(Player var1);

    public long getFlightStartTime(Player var1);

    public long getLastFlapTime(Player var1);

    public boolean isFlying(Player var1);

    public void startFlying(Player var1);

    public void stopFlying(Player var1);

    public void setDashTicks(int var1);

    public void setLastFlapTime(long var1);

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        final PlayerDataImpl impl = new PlayerDataImpl();

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            if (cap == INSTANCE) {
                return LazyOptional.of(() -> this.impl);
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.deserializeNBT(nbt);
        }
    }
}

