/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.research;

import elucent.eidolon.mixin.AbstractContainerMenuMixin;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class ResearchTask {
    public abstract CompoundTag write();

    public abstract void read(CompoundTag var1);

    public abstract CompletenessResult isComplete(AbstractContainerMenu var1, Player var2, int var3);

    public abstract void onComplete(AbstractContainerMenu var1, Player var2, int var3);

    @OnlyIn(value=Dist.CLIENT)
    public abstract int getWidth();

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawIcon(GuiGraphics var1, ResourceLocation var2, int var3, int var4);

    @OnlyIn(value=Dist.CLIENT)
    public int drawCustom(@NotNull GuiGraphics stack, ResourceLocation texture, int x, int y) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDefaultWidth() {
        return 64;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltip(@NotNull GuiGraphics stack, AbstractContainerScreen<?> gui, double mouseX, double mouseY) {
    }

    public int getSlotCount() {
        return 0;
    }

    public void modifyContainer(AbstractContainerMenu menu, int x, int y) {
    }

    public static class XP
    extends ResearchTask {
        int levels;

        public XP(Random random) {
            this.levels = random.nextInt(1, 6);
        }

        public XP(int i) {
            this.levels = i;
        }

        @Override
        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("levels", this.levels);
            return tag;
        }

        @Override
        public void read(CompoundTag tag) {
            this.levels = tag.m_128451_("levels");
        }

        @Override
        public int getWidth() {
            return this.getDefaultWidth();
        }

        @Override
        public void drawIcon(GuiGraphics stack, ResourceLocation texture, int x, int y) {
            int offY = Minecraft.m_91087_().f_91074_.f_36078_ < this.levels ? 16 : 0;
            stack.m_280398_(texture, x, y, 0, (float)((this.levels - 1) * 16), (float)(224 + offY), 16, 16, 256, 256);
        }

        @Override
        public CompletenessResult isComplete(AbstractContainerMenu menu, Player player, int slotStart) {
            return new CompletenessResult(slotStart, player.f_36078_ >= this.levels);
        }

        @Override
        public void drawTooltip(@NotNull GuiGraphics stack, AbstractContainerScreen<?> gui, double mouseX, double mouseY) {
            MutableComponent tooltip = this.levels == 1 ? Component.m_237115_((String)"container.enchant.level.one") : Component.m_237110_((String)"container.enchant.level.many", (Object[])new Object[]{this.levels});
            stack.m_280557_(Minecraft.m_91087_().f_91062_, (Component)tooltip, (int)mouseX, (int)mouseY);
        }

        @Override
        public void onComplete(AbstractContainerMenu menu, Player player, int slotStart) {
            player.m_6749_(-this.levels);
        }
    }

    public static class TaskItems
    extends ResearchTask {
        List<ItemStack> items;
        final InternalContainer container;

        public TaskItems(ItemStack ... stacks) {
            this.items = List.of(stacks);
            this.container = new InternalContainer();
        }

        public TaskItems(List<ItemStack> stacks) {
            this.items = stacks;
            this.container = new InternalContainer();
        }

        public static Function<Random, ResearchTask> fromTag(TagKey<Item> tagKey, int maxCount) {
            return random -> {
                List<ItemStack> items = List.of(Ingredient.m_204132_((TagKey)tagKey).m_43908_());
                for (ItemStack item : items) {
                    if (!item.m_41753_()) continue;
                    item.m_41764_(random.nextInt(1, maxCount));
                }
                return new TaskItems(items.get(random.nextInt(items.size())));
            };
        }

        @Override
        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("stacks", (Tag)new ListTag());
            return this.items.stream().map(s -> s.m_41739_(new CompoundTag())).reduce(tag, (t, s) -> {
                t.m_128437_("stacks", 10).add(s);
                return t;
            });
        }

        @Override
        public void read(CompoundTag tag) {
            ListTag list = tag.m_128437_("stacks", 10);
            for (Tag t : list) {
                this.items.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)t)));
            }
        }

        @Override
        public int getWidth() {
            return this.getDefaultWidth() + 8 + 17 * this.items.size();
        }

        @Override
        public void drawIcon(GuiGraphics stack, ResourceLocation texture, int x, int y) {
            int offset = (this.items.size() - 1) * -4;
            ItemRenderer ir = Minecraft.m_91087_().m_91291_();
            for (int i = 0; i < this.items.size(); ++i) {
                stack.m_280480_(this.items.get(i), x + i * 8 + offset, y);
                stack.m_280302_(Minecraft.m_91087_().f_91062_, this.items.get(i), x + i * 8 + offset, y, null);
            }
        }

        @Override
        public int drawCustom(@NotNull GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
            guiGraphics.m_280398_(texture, x, y, 0, 88.0f, 224.0f, 1, 32, 256, 256);
            ++x;
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.size() == 1) {
                    guiGraphics.m_280398_(texture, x, y, 0, 192.0f, 0.0f, 22, 32, 256, 256);
                    x += 22;
                    continue;
                }
                if (i == 0) {
                    guiGraphics.m_280398_(texture, x, y, 0, 192.0f, 32.0f, 20, 32, 256, 256);
                    x += 19;
                    continue;
                }
                if (i == this.items.size() - 1) {
                    guiGraphics.m_280398_(texture, x, y, 0, 228.0f, 32.0f, 20, 32, 256, 256);
                    x += 20;
                    continue;
                }
                guiGraphics.m_280398_(texture, x, y, 0, 211.0f, 32.0f, 18, 32, 256, 256);
                x += 17;
            }
            guiGraphics.m_280398_(texture, x, y, 0, 88.0f, 224.0f, 2, 32, 256, 256);
            x += 2;
            return 8 + 17 * this.items.size();
        }

        @Override
        public void drawTooltip(@NotNull GuiGraphics stack, AbstractContainerScreen<?> gui, double mouseX, double mouseY) {
            List tooltip = Screen.m_280152_((Minecraft)gui.getMinecraft(), (ItemStack)this.items.get(0));
            stack.m_280666_(Minecraft.m_91087_().f_91062_, tooltip, (int)mouseX, (int)mouseY);
        }

        @Override
        public int getSlotCount() {
            return this.items.size();
        }

        @Override
        public void modifyContainer(AbstractContainerMenu menu, int x, int y) {
            for (int i = 0; i < this.items.size(); ++i) {
                final ItemStack stack = this.items.get(i);
                ((AbstractContainerMenuMixin)menu).callAddSlot(new Slot(this.container, i, x + 11 + 17 * i, y + 7){

                    public boolean m_5857_(@NotNull ItemStack pStack) {
                        return ItemStack.m_150942_((ItemStack)pStack, (ItemStack)stack);
                    }
                });
            }
        }

        @Override
        public CompletenessResult isComplete(AbstractContainerMenu menu, Player player, int slotStart) {
            boolean isMatching = true;
            for (int i = 0; i < this.items.size() && isMatching; ++i) {
                if (menu.m_38927_().size() <= slotStart + i) {
                    isMatching = false;
                    continue;
                }
                ItemStack slot = menu.m_38853_(slotStart + i).m_7993_();
                if (!ItemStack.m_150942_((ItemStack)this.items.get(i), (ItemStack)slot)) {
                    isMatching = false;
                }
                if (slot.m_41613_() >= this.items.get(i).m_41613_()) continue;
                isMatching = false;
            }
            return new CompletenessResult(slotStart + this.items.size(), isMatching);
        }

        @Override
        public void onComplete(AbstractContainerMenu menu, Player player, int slotStart) {
            for (int i = 0; i < this.items.size(); ++i) {
                menu.m_38853_(slotStart + i).m_6201_(this.items.get(i).m_41613_());
            }
        }

        class InternalContainer
        implements Container {
            final List<ItemStack> items = new ArrayList<ItemStack>();

            InternalContainer() {
            }

            protected void updateItems() {
                while (this.items.size() < TaskItems.this.items.size()) {
                    this.items.add(ItemStack.f_41583_);
                }
            }

            public void m_6211_() {
                this.items.clear();
            }

            public int m_6643_() {
                return TaskItems.this.items.size();
            }

            public boolean m_7983_() {
                for (ItemStack s : this.items) {
                    if (s.m_41619_()) continue;
                    return false;
                }
                return true;
            }

            @NotNull
            public ItemStack m_8020_(int slot) {
                this.updateItems();
                return this.items.get(slot);
            }

            @NotNull
            public ItemStack m_7407_(int slot, int amount) {
                this.updateItems();
                ItemStack stack = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
                if (!stack.m_41619_()) {
                    this.m_6596_();
                }
                return stack;
            }

            @NotNull
            public ItemStack m_8016_(int slot) {
                this.updateItems();
                ItemStack itemstack = this.items.get(slot);
                if (itemstack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                this.items.set(slot, ItemStack.f_41583_);
                return itemstack;
            }

            public void m_6836_(int slot, @NotNull ItemStack stack) {
                this.updateItems();
                this.items.set(slot, stack);
            }

            public void m_6596_() {
            }

            public boolean m_6542_(@NotNull Player p_18946_) {
                return true;
            }
        }
    }

    public record CompletenessResult(int nextSlot, boolean complete) {
    }
}

