/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.annotation;

import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.scene.annotation.AnnotationTagCompiler;
import guideme.scene.annotation.InWorldLineAnnotation;
import guideme.scene.annotation.SceneAnnotation;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LineAnnotationElementCompiler
extends AnnotationTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("LineAnnotation");
    }

    @Override
    @Nullable
    protected SceneAnnotation createAnnotation(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        Vector3f from = MdxAttrs.getVector3(compiler, errorSink, el, "from", (Vector3fc)new Vector3f());
        Vector3f to = MdxAttrs.getVector3(compiler, errorSink, el, "to", (Vector3fc)new Vector3f());
        ColorValue color = MdxAttrs.getColor(compiler, errorSink, el, "color", ConstantColor.WHITE);
        float thickness = MdxAttrs.getFloat(compiler, errorSink, el, "thickness", 0.03125f);
        boolean alwaysOnTop = MdxAttrs.getBoolean(compiler, errorSink, el, "alwaysOnTop", false);
        InWorldLineAnnotation annotation = new InWorldLineAnnotation(from, to, color, thickness);
        annotation.setAlwaysOnTop(alwaysOnTop);
        return annotation;
    }
}

