/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.util;

import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class LangUtil {
    private LangUtil() {
    }

    public static Set<String> getValidLanguages() {
        Minecraft client = Minecraft.m_91087_();
        if (client != null) {
            return client.m_91102_().m_264450_().keySet();
        }
        return Set.of("en_us");
    }

    public static String getCurrentLanguage() {
        Minecraft client = Minecraft.m_91087_();
        if (client != null) {
            return client.m_91102_().m_264236_();
        }
        return "en_us";
    }

    public static ResourceLocation getTranslatedAsset(ResourceLocation assetId, String language) {
        return assetId.m_246208_("_" + language + "/");
    }

    public static ResourceLocation stripLangFromPageId(ResourceLocation pageId, Set<String> supportedLanguages) {
        String path = pageId.m_135815_();
        int firstSep = path.indexOf("/");
        if (firstSep == -1) {
            return pageId;
        }
        if (path.charAt(0) != '_') {
            return pageId;
        }
        if (firstSep + 1 >= path.length()) {
            return pageId;
        }
        String potentialLanguage = path.substring(1, firstSep);
        if (supportedLanguages.contains(potentialLanguage)) {
            return pageId.m_247449_(path.substring(firstSep + 1));
        }
        return pageId;
    }

    @Nullable
    public static String getLangFromPageId(ResourceLocation pageId, Set<String> supportedLanguages) {
        String path = pageId.m_135815_();
        int firstSep = path.indexOf("/");
        if (firstSep == -1) {
            return null;
        }
        if (path.charAt(0) != '_') {
            return null;
        }
        if (firstSep + 1 >= path.length()) {
            return null;
        }
        String potentialLanguage = path.substring(1, firstSep);
        if (supportedLanguages.contains(potentialLanguage)) {
            return potentialLanguage;
        }
        return null;
    }
}

