/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.DoubleValues;
import guideme.internal.shaded.lucene.search.DoubleValuesSource;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.VectorScorer;
import java.io.IOException;

abstract class VectorSimilarityValuesSource
extends DoubleValuesSource {
    protected final String fieldName;

    public VectorSimilarityValuesSource(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        final VectorScorer scorer = this.getScorer(ctx);
        if (scorer == null) {
            return DoubleValues.EMPTY;
        }
        final DocIdSetIterator iterator = scorer.iterator();
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return scorer.score();
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doc >= iterator.docID() && (iterator.docID() == doc || iterator.advance(doc) == doc);
            }
        };
    }

    protected abstract VectorScorer getScorer(LeafReaderContext var1) throws IOException;

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
        return this;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }
}

