/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.payloads;

import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import guideme.internal.shaded.lucene.analysis.payloads.FloatEncoder;
import guideme.internal.shaded.lucene.analysis.payloads.IdentityEncoder;
import guideme.internal.shaded.lucene.analysis.payloads.IntegerEncoder;
import guideme.internal.shaded.lucene.analysis.payloads.PayloadEncoder;
import guideme.internal.shaded.lucene.util.ResourceLoader;
import guideme.internal.shaded.lucene.util.ResourceLoaderAware;
import java.util.Map;

public class DelimitedPayloadTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "delimitedPayload";
    public static final String ENCODER_ATTR = "encoder";
    public static final String DELIMITER_ATTR = "delimiter";
    private final String encoderClass;
    private final char delimiter;
    private PayloadEncoder encoder;

    public DelimitedPayloadTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.encoderClass = this.require(args, ENCODER_ATTR);
        this.delimiter = this.getChar(args, DELIMITER_ATTR, '|');
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public DelimitedPayloadTokenFilterFactory() {
        throw DelimitedPayloadTokenFilterFactory.defaultCtorException();
    }

    @Override
    public DelimitedPayloadTokenFilter create(TokenStream input) {
        return new DelimitedPayloadTokenFilter(input, this.delimiter, this.encoder);
    }

    @Override
    public void inform(ResourceLoader loader) {
        this.encoder = this.encoderClass.equals("float") ? new FloatEncoder() : (this.encoderClass.equals("integer") ? new IntegerEncoder() : (this.encoderClass.equals("identity") ? new IdentityEncoder() : loader.newInstance(this.encoderClass, PayloadEncoder.class)));
    }
}

