/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import guideme.Guide;
import guideme.compiler.PageCompiler;
import guideme.compiler.ParsedGuidePage;
import guideme.internal.GuideMEClient;
import guideme.internal.GuideRegistry;
import guideme.internal.MutableGuide;
import guideme.internal.datadriven.DataDrivenGuide;
import guideme.internal.util.LangUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GuideReloadListener
extends SimplePreparableReloadListener<Result> {
    private static final Logger LOG = LoggerFactory.getLogger(GuideReloadListener.class);
    private static final Gson GSON = new Gson();

    GuideReloadListener() {
    }

    protected Result prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        IdentityHashMap<ResourceLocation, Map<ResourceLocation, ParsedGuidePage>> guidePages = new IdentityHashMap<ResourceLocation, Map<ResourceLocation, ParsedGuidePage>>();
        String language = Minecraft.m_91087_().m_91102_().m_264236_();
        if (GuideMEClient.instance().isIgnoreTranslatedGuides()) {
            language = null;
        }
        Set<String> languages = GuideReloadListener.getAllLanguages(resourceManager);
        Map<ResourceLocation, MutableGuide> dataDrivenGuides = GuideReloadListener.loadDataDrivenGuides(resourceManager);
        for (MutableGuide guide : dataDrivenGuides.values()) {
            guidePages.put(guide.getId(), GuideReloadListener.loadPages(resourceManager, guide.getContentRootFolder(), guide.getDefaultLanguage(), language, languages));
        }
        for (MutableGuide guide : GuideRegistry.getStaticGuides()) {
            if (guidePages.containsKey(guide.getId())) continue;
            guidePages.put(guide.getId(), GuideReloadListener.loadPages(resourceManager, guide.getContentRootFolder(), guide.getDefaultLanguage(), language, languages));
        }
        profiler.m_7241_();
        return new Result(dataDrivenGuides, guidePages, languages);
    }

    private static Set<String> getAllLanguages(ResourceManager resourceManager) {
        HashSet<String> result = new HashSet<String>();
        Iterator it = resourceManager.m_7536_().iterator();
        while (it.hasNext()) {
            try {
                LanguageMetadataSection section = (LanguageMetadataSection)((PackResources)it.next()).m_5550_((MetadataSectionSerializer)LanguageMetadataSection.f_263724_);
                if (section == null) continue;
                result.addAll(section.f_119097_().keySet());
            }
            catch (Exception exception) {}
        }
        return result;
    }

    protected void apply(Result result, ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        LOG.info("Data driven guides: {}", result.dataDrivenGuides.keySet());
        GuideRegistry.setDataDriven(result.dataDrivenGuides);
        for (MutableGuide guide : GuideRegistry.getAll()) {
            Map<ResourceLocation, ParsedGuidePage> pagesForGuide = result.guidePages.getOrDefault(guide.getId(), Map.of());
            profiler.m_6180_(guide.getId().toString());
            guide.setPages(pagesForGuide);
            profiler.m_7238_();
        }
        profiler.m_7241_();
    }

    public String m_7812_() {
        return "GuideME Reload Listener";
    }

    private static Map<ResourceLocation, MutableGuide> loadDataDrivenGuides(ResourceManager resourceManager) {
        HashMap dataDrivenGuideJsons = new HashMap();
        SimpleJsonResourceReloadListener.m_278771_((ResourceManager)resourceManager, (String)"guideme_guides", (Gson)GSON, dataDrivenGuideJsons);
        HashMap<ResourceLocation, MutableGuide> dataDrivenGuides = new HashMap<ResourceLocation, MutableGuide>();
        for (Map.Entry entry : dataDrivenGuideJsons.entrySet()) {
            ResourceLocation guideId = (ResourceLocation)entry.getKey();
            DataResult result = DataDrivenGuide.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()));
            DataResult.PartialResult error = result.error().orElse(null);
            if (error != null) {
                LOG.error("Failed to load data driven guide {}: {}", (Object)guideId, (Object)error.message());
                continue;
            }
            DataDrivenGuide guideSpec = (DataDrivenGuide)result.get().orThrow();
            MutableGuide guide = (MutableGuide)Guide.builder(guideId).register(false).itemSettings(guideSpec.itemSettings()).defaultLanguage(guideSpec.defaultLanguage()).build();
            dataDrivenGuides.put(guideId, guide);
        }
        return dataDrivenGuides;
    }

    private static Map<ResourceLocation, ParsedGuidePage> loadPages(ResourceManager resourceManager, String contentRoot, String defaultLanguage, @Nullable String currentLanguage, Set<String> languages) {
        HashMap<ResourceLocation, ParsedGuidePage> pagesForGuide = new HashMap<ResourceLocation, ParsedGuidePage>();
        Map resources = resourceManager.m_214159_(contentRoot, location -> location.m_135815_().endsWith(".md"));
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation translatedResourceId;
            Resource translatedPage;
            ResourceLocation pageId = new ResourceLocation(((ResourceLocation)entry.getKey()).m_135827_(), ((ResourceLocation)entry.getKey()).m_135815_().substring((contentRoot + "/").length()));
            Resource resource = (Resource)entry.getValue();
            if (LangUtil.getLangFromPageId(pageId, languages) != null) continue;
            String language = defaultLanguage;
            if (currentLanguage != null && (translatedPage = (Resource)resources.get(translatedResourceId = LangUtil.getTranslatedAsset(pageId, currentLanguage).m_246208_(contentRoot + "/"))) != null) {
                language = currentLanguage;
                resource = translatedPage;
            }
            String sourcePackId = resource.m_215506_();
            try {
                InputStream in = resource.m_215507_();
                try {
                    pagesForGuide.put(pageId, PageCompiler.parse(sourcePackId, language, pageId, in));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.error("Failed to load guidebook page {} from pack {}", new Object[]{pageId, sourcePackId, e});
            }
        }
        return pagesForGuide;
    }

    protected record Result(Map<ResourceLocation, MutableGuide> dataDrivenGuides, Map<ResourceLocation, Map<ResourceLocation, ParsedGuidePage>> guidePages, Set<String> languages) {
    }
}

