/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import io.github.mortuusars.exposure.Exposure;
import java.util.Optional;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public enum ColorChannel implements StringRepresentable
{
    RED(-2600386),
    GREEN(-8665525),
    BLUE(-11635762);

    private final int color;

    private ColorChannel(int color) {
        this.color = color;
    }

    public int getRepresentationColor() {
        return this.color;
    }

    public static Optional<ColorChannel> fromStack(ItemStack stack) {
        if (stack.m_204117_(Exposure.Tags.Items.RED_FILTERS)) {
            return Optional.of(RED);
        }
        if (stack.m_204117_(Exposure.Tags.Items.GREEN_FILTERS)) {
            return Optional.of(GREEN);
        }
        if (stack.m_204117_(Exposure.Tags.Items.BLUE_FILTERS)) {
            return Optional.of(BLUE);
        }
        return Optional.empty();
    }

    public static ColorChannel fromStringOrDefault(String serializedName, ColorChannel defaultValue) {
        for (ColorChannel value : ColorChannel.values()) {
            if (!value.m_7912_().equals(serializedName)) continue;
            return value;
        }
        return defaultValue;
    }

    public static Optional<ColorChannel> fromString(String serializedName) {
        for (ColorChannel value : ColorChannel.values()) {
            if (!value.m_7912_().equals(serializedName)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @NotNull
    public String m_7912_() {
        return this.toString().toLowerCase();
    }
}

