/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import io.github.mortuusars.exposure.camera.infrastructure.ZoomDirection;
import io.github.mortuusars.exposure.gui.screen.element.ZoomHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public abstract class ZoomableScreen
extends Screen {
    protected final ZoomHandler zoom = new ZoomHandler();
    protected float zoomFactor = 1.0f;
    protected float scale = 1.0f;
    protected float x;
    protected float y;
    @NotNull
    protected final Minecraft minecraft = Minecraft.m_91087_();

    protected ZoomableScreen(Component title) {
        super(title);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.zoom.update(partialTick);
        this.scale = this.zoom.get() * this.zoomFactor;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean handled = super.m_7933_(keyCode, scanCode, modifiers);
        if (handled) {
            return true;
        }
        if (this.minecraft.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
        } else if (keyCode == 334 || keyCode == 61) {
            this.zoom.change(ZoomDirection.IN);
        } else if (keyCode == 333 || keyCode == 45) {
            this.zoom.change(ZoomDirection.OUT);
        } else {
            return false;
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean handled = super.m_6050_(mouseX, mouseY, delta);
        if (!handled) {
            this.zoom.change(delta >= 0.0 ? ZoomDirection.IN : ZoomDirection.OUT);
            return true;
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean handled = super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        if (!handled && button == 0) {
            float centerX = (float)this.f_96543_ / 2.0f;
            float centerY = (float)this.f_96544_ / 2.0f;
            this.x = (float)Mth.m_14008_((double)((double)this.x + dragX), (double)(-centerX), (double)centerX);
            this.y = (float)Mth.m_14008_((double)((double)this.y + dragY), (double)(-centerY), (double)centerY);
            handled = true;
        }
        return handled;
    }
}

