/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.blocks.statements;

import de.keksuccino.fancymenu.customization.action.Executable;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WhileExecutableBlock
extends AbstractExecutableBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long TIMEOUT_MILLIS = 3000L;
    @NotNull
    public LoadingRequirementContainer condition = new LoadingRequirementContainer().forceRequirementsMet(true);
    private long loopStartTime = 0L;
    private boolean hasTimedOut = false;

    public WhileExecutableBlock() {
    }

    public WhileExecutableBlock(@NotNull LoadingRequirementContainer condition) {
        this.condition = Objects.requireNonNull(condition);
    }

    @Override
    public String getBlockType() {
        return "while";
    }

    @Override
    public void execute() {
        if (this.hasTimedOut) {
            LOGGER.warn("[FANCYMENU] WhileExecutableBlock execution prevented - still in timeout state from previous timeout");
            return;
        }
        this.loopStartTime = System.currentTimeMillis();
        while (this.check() && !this.checkTimeout()) {
            super.execute();
        }
        if (this.checkTimeout()) {
            this.hasTimedOut = true;
            LOGGER.warn("[FANCYMENU] WhileExecutableBlock loop timed out after {} milliseconds!", (Object)3000L);
        } else {
            this.hasTimedOut = false;
        }
        this.loopStartTime = 0L;
    }

    private boolean checkTimeout() {
        if (this.loopStartTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.loopStartTime >= 3000L;
    }

    @Override
    public void addValuePlaceholder(@NotNull String placeholder, @NotNull Supplier<String> replaceWithSupplier) {
        super.addValuePlaceholder(placeholder, replaceWithSupplier);
        this.condition.addValuePlaceholder(placeholder, replaceWithSupplier);
    }

    @Override
    @NotNull
    public WhileExecutableBlock copy(boolean unique) {
        WhileExecutableBlock b = new WhileExecutableBlock();
        if (!unique) {
            b.identifier = this.identifier;
        }
        if (this.getAppendedBlock() != null) {
            b.setAppendedBlock((AbstractExecutableBlock)this.getAppendedBlock().copy(unique));
        }
        for (Executable e : this.executables) {
            b.addExecutable(e.copy(unique));
        }
        b.condition = this.condition.copy(unique);
        b.valuePlaceholders.putAll(this.valuePlaceholders);
        return b;
    }

    public boolean check() {
        return this.condition.requirementsMet();
    }

    @Override
    @NotNull
    public PropertyContainer serialize() {
        PropertyContainer container = super.serialize();
        String key = "[while_executable_block_body:" + this.getIdentifier() + "]";
        container.putProperty(key, this.condition.identifier);
        this.condition.serializeToExistingPropertyContainer(container);
        return container;
    }

    public static WhileExecutableBlock deserializeEmptyWithIdentifier(@NotNull PropertyContainer serialized, @NotNull String identifier) {
        WhileExecutableBlock b = new WhileExecutableBlock();
        b.identifier = identifier;
        for (Map.Entry<String, String> m : serialized.getProperties().entrySet()) {
            if (!m.getKey().equals("[while_executable_block_body:" + identifier + "]")) continue;
            LoadingRequirementContainer lrc = LoadingRequirementContainer.deserializeWithIdentifier(m.getValue(), serialized);
            if (lrc == null) break;
            b.condition = lrc;
            break;
        }
        return b;
    }
}

