/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.util;

import andrews.table_top_craft.network.TTCNetwork;
import andrews.table_top_craft.network.client.MessageClientChessAnimationState;
import andrews.table_top_craft.network.client.MessageClientChessParticles;
import andrews.table_top_craft.network.client.MessageClientConnectFourAnimationState;
import andrews.table_top_craft.network.client.MessageClientOpenChessPieceSelectionScreen;
import andrews.table_top_craft.network.client.MessageClientOpenChessPromotionScreen;
import andrews.table_top_craft.network.client.MessageClientPlayChessTimerSound;
import andrews.table_top_craft.network.server.MessageServerAdjustChessTimerTime;
import andrews.table_top_craft.network.server.MessageServerChangePieceScale;
import andrews.table_top_craft.network.server.MessageServerChangePieceSet;
import andrews.table_top_craft.network.server.MessageServerChangePieceType;
import andrews.table_top_craft.network.server.MessageServerChessVisuals;
import andrews.table_top_craft.network.server.MessageServerDoChessBoardInteraction;
import andrews.table_top_craft.network.server.MessageServerDoConnectFourInteraction;
import andrews.table_top_craft.network.server.MessageServerDoPawnPromotion;
import andrews.table_top_craft.network.server.MessageServerLoadFEN;
import andrews.table_top_craft.network.server.MessageServerNewChessGame;
import andrews.table_top_craft.network.server.MessageServerOpenGUIWithServerPlayer;
import andrews.table_top_craft.network.server.MessageServerPauseChessTimer;
import andrews.table_top_craft.network.server.MessageServerResetChessTimer;
import andrews.table_top_craft.network.server.MessageServerRotateChessPieceFigure;
import andrews.table_top_craft.network.server.MessageServerSetColor;
import andrews.table_top_craft.network.server.MessageServerSetColors;
import andrews.table_top_craft.network.server.MessageServerSetPieceSet;
import andrews.table_top_craft.network.server.MessageServerShowAvailableMoves;
import andrews.table_top_craft.network.server.MessageServerShowPreviousMove;
import andrews.table_top_craft.network.server.MessageServerShowTileInfo;
import andrews.table_top_craft.network.server.MessageServerUseCustomPlate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class NetworkUtil {
    public static void openChessPieceSelectionFromServer(BlockPos pos, boolean isStandardSetUnlocked, boolean isClassicSetUnlocked, boolean isPandorasCreaturesSetUnlocked, ServerPlayer serverPlayer) {
        TTCNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageClientOpenChessPieceSelectionScreen(pos, isStandardSetUnlocked, isClassicSetUnlocked, isPandorasCreaturesSetUnlocked));
    }

    public static void setChessAnimationForAllTracking(Level level, BlockPos pos, byte actionType, byte currentCord, byte destCord) {
        TTCNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new MessageClientChessAnimationState(pos, actionType, currentCord, destCord));
    }

    public static void setChessAnimationForAllTracking(Level level, BlockPos pos, byte actionType) {
        NetworkUtil.setChessAnimationForAllTracking(level, pos, actionType, (byte)0, (byte)0);
    }

    public static void setConnectFourAnimationForAllTracking(Level level, BlockPos pos, byte destCord) {
        TTCNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new MessageClientConnectFourAnimationState(pos, destCord));
    }

    public static void openChessPromotionFromServer(BlockPos pos, boolean isWhite, ServerPlayer serverPlayer) {
        TTCNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageClientOpenChessPromotionScreen(pos, isWhite));
    }

    public static void playChesTimerSoundFromServer(Level level, BlockPos pos, byte id) {
        TTCNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new MessageClientPlayChessTimerSound(pos, id));
    }

    public static void playChesParticlesFromServer(Level level, BlockPos pos, byte destCord, boolean isWhite, float xSpeed, float ySpeed, float zSpeed) {
        TTCNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new MessageClientChessParticles(pos, destCord, isWhite, xSpeed, ySpeed, zSpeed));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void newChessGameMessage(BlockPos pos) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerNewChessGame(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showTileInfoMessage(BlockPos pos) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerShowTileInfo(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void loadFENMessage(BlockPos pos, String FEN) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerLoadFEN(pos, FEN));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showAvailableMovesMessage(BlockPos pos) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerShowAvailableMoves(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showPreviousMoveMessage(BlockPos pos) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerShowPreviousMove(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setColorMessage(int colorType, BlockPos pos, String color) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerSetColor(colorType, pos, color));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void useCustomPlateMessage(BlockPos pos) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerUseCustomPlate(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setColorsMessage(int colorType, BlockPos pos, String color, String color2) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerSetColors(colorType, pos, color, color2));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void rotateChessPieceFigure(BlockPos pos) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerRotateChessPieceFigure(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void doChessBoardInteraction(BlockPos pos, byte tileCoordinate) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerDoChessBoardInteraction(pos, tileCoordinate));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setChessPieceSet(BlockPos pos, int pieceSet) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerSetPieceSet(pos, pieceSet));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void changePieceSet(BlockPos pos, byte value) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerChangePieceSet(pos, value));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void changePieceType(BlockPos pos, byte value) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerChangePieceType(pos, value));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setPieceScale(BlockPos pos, double value) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerChangePieceScale(pos, value));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openGuiWithServerPlayer(BlockPos pos) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerOpenGUIWithServerPlayer(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void adjustChessTimerTime(BlockPos pos, byte type, byte category) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerAdjustChessTimerTime(pos, type, category));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void toggleChessVisuals(BlockPos pos, byte type) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerChessVisuals(pos, type));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void doPawnPromotion(BlockPos pos, byte type) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerDoPawnPromotion(pos, type));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void resetChessTimerTime(BlockPos pos) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerResetChessTimer(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void pauseChessTimerTime(BlockPos pos) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerPauseChessTimer(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void doConnectFourInteraction(BlockPos pos, byte column) {
        TTCNetwork.CHANNEL.sendToServer((Object)new MessageServerDoConnectFourInteraction(pos, column));
    }
}

