/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.objects.blocks;

import andrews.table_top_craft.block_entities.ChessTimerBlockEntity;
import andrews.table_top_craft.screens.chess_timer.menus.ChessTimerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChessTimerBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<PressedButton> PRESSED_BUTTON = EnumProperty.m_61587_((String)"pressed_button", PressedButton.class);
    private static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)6.0, (double)15.0);
    private static final VoxelShape Y_AXIS_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)6.0, (double)11.0);

    public ChessTimerBlock(MapColor mapColor, SoundType soundType) {
        super(ChessTimerBlock.getProperties(mapColor, soundType));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(PRESSED_BUTTON, (Comparable)((Object)PressedButton.NONE)));
    }

    private static BlockBehaviour.Properties getProperties(MapColor mapColor, SoundType soundType) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
        properties.m_284180_(mapColor);
        properties.m_60918_(soundType);
        properties.m_60978_(1.8f);
        properties.m_60955_();
        return properties;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ChessTimerBlockEntity blockEntity;
        boolean isTimerZero = false;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof ChessTimerBlockEntity) {
            blockEntity = (ChessTimerBlockEntity)blockEntity2;
            boolean bl = isTimerZero = blockEntity.getLeftTimer() == 0L || blockEntity.getRightTimer() == 0L;
        }
        if (!isTimerZero && !player.m_6144_()) {
            if (((PressedButton)((Object)state.m_61143_(PRESSED_BUTTON))).equals((Object)PressedButton.NONE)) {
                PressedButton pressedButton = PressedButton.LEFT;
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    default: {
                        break;
                    }
                    case NORTH: {
                        pressedButton = (double)pos.m_123341_() + 0.5 > player.m_20185_() ? PressedButton.LEFT : PressedButton.RIGHT;
                        break;
                    }
                    case SOUTH: {
                        pressedButton = (double)pos.m_123341_() + 0.5 > player.m_20185_() ? PressedButton.RIGHT : PressedButton.LEFT;
                        break;
                    }
                    case EAST: {
                        pressedButton = (double)pos.m_123343_() + 0.5 > player.m_20189_() ? PressedButton.LEFT : PressedButton.RIGHT;
                        break;
                    }
                    case WEST: {
                        pressedButton = (double)pos.m_123343_() + 0.5 > player.m_20189_() ? PressedButton.RIGHT : PressedButton.LEFT;
                    }
                }
                level.m_7731_(pos, (BlockState)state.m_61124_(PRESSED_BUTTON, (Comparable)((Object)pressedButton)), 2);
            }
            if (((PressedButton)((Object)state.m_61143_(PRESSED_BUTTON))).equals((Object)PressedButton.LEFT)) {
                if (!level.m_5776_() && (blockEntity2 = level.m_7702_(pos)) instanceof ChessTimerBlockEntity) {
                    blockEntity = (ChessTimerBlockEntity)blockEntity2;
                    if (blockEntity.leftTimerCache < System.currentTimeMillis() && blockEntity.lastSwitchTime != 0L) {
                        blockEntity.leftTimerCache += System.currentTimeMillis() - blockEntity.lastSwitchTime;
                    }
                }
                level.m_7731_(pos, (BlockState)state.m_61124_(PRESSED_BUTTON, (Comparable)((Object)PressedButton.RIGHT)), 2);
            }
            if (((PressedButton)((Object)state.m_61143_(PRESSED_BUTTON))).equals((Object)PressedButton.RIGHT)) {
                if (!level.m_5776_() && (blockEntity2 = level.m_7702_(pos)) instanceof ChessTimerBlockEntity) {
                    blockEntity = (ChessTimerBlockEntity)blockEntity2;
                    if (blockEntity.rightTimerCache < System.currentTimeMillis() && blockEntity.lastSwitchTime != 0L) {
                        blockEntity.rightTimerCache += System.currentTimeMillis() - blockEntity.lastSwitchTime;
                    }
                }
                level.m_7731_(pos, (BlockState)state.m_61124_(PRESSED_BUTTON, (Comparable)((Object)PressedButton.LEFT)), 2);
            }
            if (!level.m_5776_() && (blockEntity2 = level.m_7702_(pos)) instanceof ChessTimerBlockEntity) {
                blockEntity = (ChessTimerBlockEntity)blockEntity2;
                blockEntity.lastSwitchTime = System.currentTimeMillis();
            }
            level.m_245747_(pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 0.6f, false);
        } else {
            blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof ChessTimerBlockEntity) {
                blockEntity = (ChessTimerBlockEntity)blockEntity2;
                if (level.f_46443_) {
                    ChessTimerScreen.open(blockEntity);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            default -> X_AXIS_AABB;
            case Direction.NORTH, Direction.SOUTH -> Y_AXIS_AABB;
        };
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        ChessTimerBlockEntity blockEntity = (ChessTimerBlockEntity)level.m_7702_(pos);
        if (blockEntity != null) {
            if (blockEntity.getLeftTimer() == 0L && blockEntity.getRightTimer() == 0L) {
                return switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    default -> 0;
                    case Direction.NORTH, Direction.SOUTH -> {
                        if (direction.equals((Object)Direction.WEST) || direction.equals((Object)Direction.EAST)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case Direction.EAST, Direction.WEST -> direction.equals((Object)Direction.NORTH) || direction.equals((Object)Direction.SOUTH) ? 15 : 0;
                };
            }
            if (blockEntity.getLeftTimer() == 0L) {
                return switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    default -> 0;
                    case Direction.NORTH -> {
                        if (direction.equals((Object)Direction.WEST)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case Direction.SOUTH -> {
                        if (direction.equals((Object)Direction.EAST)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case Direction.EAST -> {
                        if (direction.equals((Object)Direction.NORTH)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case Direction.WEST -> direction.equals((Object)Direction.SOUTH) ? 15 : 0;
                };
            }
            if (blockEntity.getRightTimer() == 0L) {
                return switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    default -> 0;
                    case Direction.NORTH -> {
                        if (direction.equals((Object)Direction.EAST)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case Direction.SOUTH -> {
                        if (direction.equals((Object)Direction.WEST)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case Direction.EAST -> {
                        if (direction.equals((Object)Direction.SOUTH)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case Direction.WEST -> direction.equals((Object)Direction.NORTH) ? 15 : 0;
                };
            }
        }
        return 0;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{PRESSED_BUTTON});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChessTimerBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntity) {
        return (level, pos, state, blockEntity) -> ChessTimerBlockEntity.tick(level, pos, state, (ChessTimerBlockEntity)blockEntity);
    }

    public static enum PressedButton implements StringRepresentable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private PressedButton(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

