/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.player;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.KingPiece;
import andrews.table_top_craft.game_logic.chess.player.MoveStatus;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;

public abstract class BaseChessPlayer {
    protected final Board board;
    protected final KingPiece playerKing;
    protected final Collection<BaseMove> legalMoves;
    private final boolean isInCheck;

    BaseChessPlayer(Board board, Collection<BaseMove> legalMoves, Collection<BaseMove> opponentMoves) {
        this.board = board;
        this.playerKing = this.establishKing();
        this.isInCheck = !BaseChessPlayer.calculateAttacksOnTile(this.playerKing.getPiecePosition(), opponentMoves).isEmpty();
        this.legalMoves = ImmutableList.copyOf((Iterable)Iterables.concat(legalMoves, this.calculateKingCastles(legalMoves, opponentMoves)));
    }

    public KingPiece getPlayerKing() {
        return this.playerKing;
    }

    public Collection<BaseMove> getLegalMoves() {
        return this.legalMoves;
    }

    protected static Collection<BaseMove> calculateAttacksOnTile(int piecePosition, Collection<BaseMove> moves) {
        ArrayList<BaseMove> attackMoves = new ArrayList<BaseMove>();
        for (BaseMove move : moves) {
            if (piecePosition != move.getDestinationCoordinate()) continue;
            attackMoves.add(move);
        }
        return ImmutableList.copyOf(attackMoves);
    }

    private KingPiece establishKing() {
        for (BasePiece piece : this.getActivePieces()) {
            if (!piece.getPieceType().isKing()) continue;
            return (KingPiece)piece;
        }
        throw new RuntimeException("The active Chess Pieces do not contain a King Piece! Not a valid Board!");
    }

    public boolean isMoveLegal(BaseMove move) {
        return this.legalMoves.contains(move);
    }

    public boolean isInCheck() {
        return this.isInCheck;
    }

    public boolean isInCheckMate() {
        return this.isInCheck && !this.hasEscapeMoves();
    }

    public boolean isInStaleMate() {
        return !this.isInCheck && !this.hasEscapeMoves();
    }

    public boolean isKingSideCastleCapable() {
        return this.playerKing.isKingSideCastleCapable();
    }

    public boolean isQueenSideCastleCapable() {
        return this.playerKing.isQueenSideCastleCapable();
    }

    protected boolean hasEscapeMoves() {
        for (BaseMove move : this.legalMoves) {
            MoveTransition transition = this.makeMove(move);
            if (!transition.getMoveStatus().isDone()) continue;
            return true;
        }
        return false;
    }

    public boolean isCastled() {
        return false;
    }

    public MoveTransition makeMove(BaseMove move) {
        if (!this.isMoveLegal(move)) {
            return new MoveTransition(this.board, move, MoveStatus.ILLEGAL_MOVE);
        }
        Board transitionBoard = move.execute();
        Collection<BaseMove> kingAttacks = BaseChessPlayer.calculateAttacksOnTile(transitionBoard.getCurrentChessPlayer().getOpponent().getPlayerKing().getPiecePosition(), transitionBoard.getCurrentChessPlayer().getLegalMoves());
        if (!kingAttacks.isEmpty()) {
            return new MoveTransition(this.board, move, MoveStatus.LEAVES_PLAYER_IN_CHECK);
        }
        return new MoveTransition(transitionBoard, move, MoveStatus.DONE);
    }

    public abstract Collection<BasePiece> getActivePieces();

    public abstract PieceColor getPieceColor();

    public abstract BaseChessPlayer getOpponent();

    protected abstract Collection<BaseMove> calculateKingCastles(Collection<BaseMove> var1, Collection<BaseMove> var2);
}

