/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities.render;

import andrews.table_top_craft.animation.system.core.AnimationHandler;
import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.block_entities.model.chess.ChessBoardPlateModel;
import andrews.table_top_craft.block_entities.model.chess.ChessHighlightModel;
import andrews.table_top_craft.block_entities.model.chess.ChessTilesInfoModel;
import andrews.table_top_craft.block_entities.model.chess.GhostModel;
import andrews.table_top_craft.block_entities.render.BufferHelpers;
import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.ChessMoveLog;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.player.BlackChessPlayer;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.game_logic.chess.player.WhiteChessPlayer;
import andrews.table_top_craft.objects.blocks.ChessBlock;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.DrawScreenHelper;
import andrews.table_top_craft.util.NBTColorSaving;
import andrews.table_top_craft.util.TTCRenderTypes;
import andrews.table_top_craft.util.shader_compat.ShaderCompatHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class ChessTileEntityRenderer
implements BlockEntityRenderer<ChessBlockEntity> {
    private static final ResourceLocation HIGHLIGHT_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess/highlight.png");
    private static final ResourceLocation TILES_INFO_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess/chess_tiles_info.png");
    private static final ResourceLocation PLATE_WHITE_TILES_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess/plate_white_tiles.png");
    private static final ResourceLocation PLATE_BLACK_TILES_TEXTURE = new ResourceLocation("table_top_craft", "textures/tile/chess/plate_black_tiles.png");
    private static final float CHESS_SCALE = 0.125f;
    private final float CHESS_PIECE_SCALE = 0.1f;
    private static final NativeImage image = new NativeImage(NativeImage.Format.RGBA, 1, 1, true);
    private static final DynamicTexture texture = new DynamicTexture(image);
    private static ResourceLocation resourceLocation = null;
    public static final ResourceLocation SHADER_COMPAT_WHITE = new ResourceLocation("table_top_craft", "textures/tile/compat/full_white.png");
    private final ChessHighlightModel highlightModel;
    private final ChessTilesInfoModel tilesInfoModel;
    private final ChessBoardPlateModel chessBoardPlateModel;
    private final GhostModel ghostModel;
    private final List<Integer> destinationCoordinates = new ArrayList<Integer>();
    private final List<BasePiece> whiteTakenPieces = new ArrayList<BasePiece>();
    private final List<BasePiece> blackTakenPieces = new ArrayList<BasePiece>();
    int cachedIdx;

    public ChessTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.highlightModel = new ChessHighlightModel(context.m_173582_(ChessHighlightModel.CHESS_HIGHLIGHT_LAYER));
        this.tilesInfoModel = new ChessTilesInfoModel(context.m_173582_(ChessTilesInfoModel.CHESS_TILES_INFO_LAYER));
        this.chessBoardPlateModel = new ChessBoardPlateModel(context.m_173582_(ChessBoardPlateModel.CHESS_BOARD_PLATE_LAYER));
        this.ghostModel = new GhostModel(context.m_173582_(GhostModel.LAYER));
    }

    public void render(ChessBlockEntity tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate;
        this.ghostModel.updateAnimations(tileEntityIn, partialTicks);
        Direction facing = Direction.NORTH;
        if (tileEntityIn.m_58898_() && (blockstate = tileEntityIn.m_58904_().m_8055_(tileEntityIn.m_58899_())).m_60734_() instanceof ChessBlock) {
            facing = (Direction)blockstate.m_61143_((Property)ChessBlock.FACING);
        }
        int lightU = LightTexture.m_109883_((int)combinedLightIn);
        int lightV = LightTexture.m_109894_((int)combinedLightIn);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.9, 0.5);
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        switch (facing) {
            default: {
                poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252392_.m_252977_(270.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
            }
        }
        if (tileEntityIn.getUseCustomPlate()) {
            this.renderChessBoardPlate(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, tileEntityIn);
        }
        if (tileEntityIn.getShouldShowTileInfo()) {
            this.renderTilesInfo(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, tileEntityIn);
        }
        poseStack.m_85849_();
        if (tileEntityIn.getBoard() != null) {
            int column;
            int rank;
            Board board = tileEntityIn.getBoard();
            WhiteChessPlayer whiteChessPlayer = (WhiteChessPlayer)board.getWhiteChessPlayer();
            BlackChessPlayer blackChessPlayer = (BlackChessPlayer)board.getBlackChessPlayer();
            boolean isWhiteInCheckmate = tileEntityIn.isWhiteCheckMate();
            boolean isBlackInCheckmate = tileEntityIn.isBlackCheckMate();
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.9, 0.5);
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            switch (facing) {
                default: {
                    poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    poseStack.m_252781_(Axis.f_252392_.m_252977_(270.0f));
                    break;
                }
                case EAST: {
                    poseStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
                }
            }
            poseStack.m_85837_(0.0625, 0.0, 0.0625);
            poseStack.m_85837_(0.375, 0.0, -0.5);
            int currentCoordinate = -1;
            poseStack.m_85836_();
            float wR = (float)NBTColorSaving.getRed(tileEntityIn.getWhitePiecesColor()) / 255.0f;
            float wG = (float)NBTColorSaving.getGreen(tileEntityIn.getWhitePiecesColor()) / 255.0f;
            float wB = (float)NBTColorSaving.getBlue(tileEntityIn.getWhitePiecesColor()) / 255.0f;
            float bR = (float)NBTColorSaving.getRed(tileEntityIn.getBlackPiecesColor()) / 255.0f;
            float bG = (float)NBTColorSaving.getGreen(tileEntityIn.getBlackPiecesColor()) / 255.0f;
            float bB = (float)NBTColorSaving.getBlue(tileEntityIn.getBlackPiecesColor()) / 255.0f;
            VertexConsumer consumer = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)SHADER_COMPAT_WHITE));
            BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(tileEntityIn.getPieceSet() + 1);
            RenderType type = TTCRenderTypes.getChessPieceSolid(resourceLocation);
            type.m_110185_();
            ShaderInstance shaderinstance = RenderSystem.getShader();
            if (!ShaderCompatHandler.isShaderActive()) {
                if (shaderinstance.f_173309_ != null) {
                    shaderinstance.f_173309_.m_5679_(RenderSystem.getProjectionMatrix());
                }
                BufferHelpers.setupRender(RenderSystem.getShader(), lightU, lightV);
                shaderinstance.m_173363_();
            }
            for (rank = 0; rank < 8; ++rank) {
                for (column = 0; column < 8; ++column) {
                    boolean isSelectedPiece;
                    boolean bl = isSelectedPiece = board.getTile(++currentCoordinate) == tileEntityIn.getSourceTile() && tileEntityIn.getHumanMovedPiece() != null;
                    if (!board.getTile(currentCoordinate).isTileOccupied()) continue;
                    PieceColor pieceColor = board.getTile(currentCoordinate).getPiece().getPieceColor();
                    BasePiece.PieceType pieceType = board.getTile(currentCoordinate).getPiece().getPieceType();
                    poseStack.m_85836_();
                    poseStack.m_85837_((double)(0.125f * (float)(-column)), 0.0, (double)(0.125f * (float)rank));
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.0, 0.15, 0.0);
                    if (pieceColor.isWhite()) {
                        poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                    }
                    if (isWhiteInCheckmate && pieceColor.isBlack()) {
                        poseStack.m_252880_(0.0f, (float)Math.abs(Math.sin((double)((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks) / 2.5)) * -0.05f, 0.0f);
                        poseStack.m_252781_(Axis.f_252393_.m_252977_((float)Math.cos((double)((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks) / 2.5) * 10.0f));
                    }
                    if (isBlackInCheckmate && pieceColor.isWhite()) {
                        poseStack.m_252880_(0.0f, (float)Math.abs(Math.sin((double)((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks) / 2.5)) * -0.05f, 0.0f);
                        poseStack.m_252781_(Axis.f_252393_.m_252977_((float)Math.cos((double)((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks) / 2.5) * 10.0f));
                    }
                    poseStack.m_252880_(0.125f * this.ghostModel.root.f_104200_ * 0.5f, 0.125f * this.ghostModel.root.f_104201_ * 0.5f, 0.125f * this.ghostModel.root.f_104202_ * 0.5f);
                    if (AnimationHandler.getElapsedSeconds(tileEntityIn.placedState) > tileEntityIn.placedState.getInTime()) {
                        poseStack.m_252781_(new Quaternionf().rotationZYX(this.ghostModel.root.f_104205_, this.ghostModel.root.f_104204_, this.ghostModel.root.f_104203_));
                    }
                    poseStack.m_85841_(this.ghostModel.root.f_233553_, this.ghostModel.root.f_233554_, this.ghostModel.root.f_233555_);
                    if (currentCoordinate == tileEntityIn.selectedPiecePos) {
                        poseStack.m_252880_(0.125f * this.ghostModel.selected.f_104200_ * 0.5f, 0.125f * this.ghostModel.selected.f_104201_ * 0.5f, 0.125f * this.ghostModel.selected.f_104202_ * 0.5f);
                        poseStack.m_252781_(new Quaternionf().rotationZYX(this.ghostModel.selected.f_104205_, this.ghostModel.selected.f_104204_, this.ghostModel.selected.f_104203_));
                    }
                    if (tileEntityIn.moveState != null) {
                        if (tileEntityIn.currentCord == currentCoordinate) {
                            poseStack.m_252880_(0.125f * this.ghostModel.moved.f_104200_ * 0.5f, 0.125f * this.ghostModel.moved.f_104201_ * 0.5f, 0.125f * this.ghostModel.moved.f_104202_ * 0.5f);
                            poseStack.m_252781_(new Quaternionf().rotationZYX(this.ghostModel.moved.f_104205_, this.ghostModel.moved.f_104204_, this.ghostModel.moved.f_104203_));
                        }
                        if (tileEntityIn.destCord == currentCoordinate) {
                            poseStack.m_252880_(0.125f * this.ghostModel.affected.f_104200_ * 0.5f, 0.125f * this.ghostModel.affected.f_104201_ * 0.5f, 0.125f * this.ghostModel.affected.f_104202_ * 0.5f);
                            poseStack.m_252781_(new Quaternionf().rotationZYX(this.ghostModel.affected.f_104205_, this.ghostModel.affected.f_104204_, this.ghostModel.affected.f_104203_));
                            poseStack.m_85841_(this.ghostModel.affected.f_233553_, this.ghostModel.affected.f_233554_, this.ghostModel.affected.f_233555_);
                        }
                        if (tileEntityIn.currentCord == 60 && board.getTile(60).getPiece().getPieceType().isKing() && (tileEntityIn.destCord == 62 && currentCoordinate == 63 || tileEntityIn.destCord == 58 && currentCoordinate == 56)) {
                            poseStack.m_252880_(0.125f * this.ghostModel.affected.f_104200_ * 0.5f, 0.125f * this.ghostModel.affected.f_104201_ * 0.5f, 0.125f * this.ghostModel.affected.f_104202_ * 0.5f);
                            poseStack.m_252781_(new Quaternionf().rotationZYX(this.ghostModel.affected.f_104205_, this.ghostModel.affected.f_104204_, this.ghostModel.affected.f_104203_));
                        }
                        if (tileEntityIn.currentCord == 4 && board.getTile(4).getPiece().getPieceType().isKing() && (tileEntityIn.destCord == 6 && currentCoordinate == 7 || tileEntityIn.destCord == 2 && currentCoordinate == 0)) {
                            poseStack.m_252880_(0.125f * this.ghostModel.affected.f_104200_ * 0.5f, 0.125f * this.ghostModel.affected.f_104201_ * 0.5f, 0.125f * this.ghostModel.affected.f_104202_ * 0.5f);
                            poseStack.m_252781_(new Quaternionf().rotationZYX(this.ghostModel.affected.f_104205_, this.ghostModel.affected.f_104204_, this.ghostModel.affected.f_104203_));
                        }
                        if (board.getTile(tileEntityIn.currentCord).getPiece().getPieceColor().isWhite() && tileEntityIn.currentCord / 8 == 3 && (tileEntityIn.currentCord % 8 - tileEntityIn.destCord % 8 == -1 || tileEntityIn.currentCord % 8 - tileEntityIn.destCord % 8 == 1) && board.getTile(tileEntityIn.destCord).getPiece() == null && currentCoordinate == tileEntityIn.destCord + 8) {
                            poseStack.m_252880_(0.125f * this.ghostModel.affected.f_104200_ * 0.5f, 0.125f * this.ghostModel.affected.f_104201_ * 0.5f, 0.125f * this.ghostModel.affected.f_104202_ * 0.5f);
                            poseStack.m_252781_(new Quaternionf().rotationZYX(this.ghostModel.affected.f_104205_, this.ghostModel.affected.f_104204_, this.ghostModel.affected.f_104203_));
                            poseStack.m_85841_(this.ghostModel.affected.f_233553_, this.ghostModel.affected.f_233554_, this.ghostModel.affected.f_233555_);
                        }
                        if (board.getTile(tileEntityIn.currentCord).getPiece().getPieceColor().isBlack() && tileEntityIn.currentCord / 8 == 4 && (tileEntityIn.currentCord % 8 - tileEntityIn.destCord % 8 == -1 || tileEntityIn.currentCord % 8 - tileEntityIn.destCord % 8 == 1) && board.getTile(tileEntityIn.destCord).getPiece() == null && currentCoordinate == tileEntityIn.destCord - 8) {
                            poseStack.m_252880_(0.125f * this.ghostModel.affected.f_104200_ * 0.5f, 0.125f * this.ghostModel.affected.f_104201_ * 0.5f, 0.125f * this.ghostModel.affected.f_104202_ * 0.5f);
                            poseStack.m_252781_(new Quaternionf().rotationZYX(this.ghostModel.affected.f_104205_, this.ghostModel.affected.f_104204_, this.ghostModel.affected.f_104203_));
                            poseStack.m_85841_(this.ghostModel.affected.f_233553_, this.ghostModel.affected.f_233554_, this.ghostModel.affected.f_233555_);
                        }
                    }
                    if (isSelectedPiece) {
                        Color colorW = new Color(Math.round(255.0f * wR), Math.round(255.0f * wG), Math.round(255.0f * wB));
                        float brightnessW = 0.2126f * (float)colorW.getRed() + 0.7152f * (float)colorW.getGreen() + 0.0722f * (float)colorW.getBlue();
                        Color colorB = new Color(Math.round(255.0f * bR), Math.round(255.0f * bG), Math.round(255.0f * bB));
                        float brightnessB = 0.2126f * (float)colorB.getRed() + 0.7152f * (float)colorB.getGreen() + 0.0722f * (float)colorB.getBlue();
                        if (!ShaderCompatHandler.isShaderActive()) {
                            poseStack.m_85836_();
                            poseStack.m_85841_(1.001f, 1.001f, 1.001f);
                            RenderSystem.polygonMode((int)1032, (int)6913);
                            float whiteLines = brightnessW * 0.5f / 255.0f;
                            float blackLines = brightnessB * 0.5f / 255.0f;
                            this.renderPiece(poseStack, tileEntityIn.getPieceSet(), pieceType, pieceColor, whiteLines, whiteLines, whiteLines, blackLines, blackLines, blackLines);
                            RenderSystem.polygonMode((int)1032, (int)6914);
                            poseStack.m_85849_();
                        }
                        colorW = brightnessW > 128.0f ? colorW.darker(0.8f, 0.0f) : colorW.brighter(0.8f, 0.0f);
                        Color color = colorB = brightnessB > 128.0f ? colorB.darker(0.8f, 0.0f) : colorB.brighter(0.8f, 0.0f);
                        if (ShaderCompatHandler.isShaderActive()) {
                            DrawScreenHelper.CHESS_PIECE_MODEL.render(poseStack, consumer, pieceType, set, pieceColor.isWhite() ? (float)colorW.getRed() / 255.0f : (float)colorB.getRed() / 255.0f, pieceColor.isWhite() ? (float)colorW.getGreen() / 255.0f : (float)colorB.getGreen() / 255.0f, pieceColor.isWhite() ? (float)colorW.getBlue() / 255.0f : (float)colorB.getBlue() / 255.0f, combinedLightIn);
                        } else {
                            this.renderPiece(poseStack, tileEntityIn.getPieceSet(), pieceType, pieceColor, (float)colorW.getRed() / 255.0f, (float)colorW.getGreen() / 255.0f, (float)colorW.getBlue() / 255.0f, (float)colorB.getRed() / 255.0f, (float)colorB.getGreen() / 255.0f, (float)colorB.getBlue() / 255.0f);
                        }
                    } else if (ShaderCompatHandler.isShaderActive()) {
                        DrawScreenHelper.CHESS_PIECE_MODEL.render(poseStack, consumer, pieceType, set, pieceColor.isWhite() ? wR : bR, pieceColor.isWhite() ? wG : bG, pieceColor.isWhite() ? wB : bB, combinedLightIn);
                    } else {
                        this.renderPiece(poseStack, tileEntityIn.getPieceSet(), pieceType, pieceColor, wR, wG, wB, bR, bG, bB);
                    }
                    poseStack.m_85849_();
                    poseStack.m_85849_();
                }
            }
            poseStack.m_85837_(-0.8125, 0.58725, 0.0625);
            this.renderTakenPieces(poseStack, bufferIn, tileEntityIn, combinedLightIn);
            if (!ShaderCompatHandler.isShaderActive()) {
                VertexBuffer.m_85931_();
                shaderinstance.m_173362_();
                type.m_110188_();
            }
            poseStack.m_85849_();
            currentCoordinate = -1;
            for (rank = 0; rank < 8; ++rank) {
                for (column = 0; column < 8; ++column) {
                    ++currentCoordinate;
                    poseStack.m_85836_();
                    poseStack.m_85837_((double)(0.125f * (float)(-column)), 0.0, (double)(0.125f * (float)rank));
                    if (tileEntityIn.getShowPreviousMove() && tileEntityIn.getMoveLog().getMoves().size() > 0) {
                        BaseMove lastMove = tileEntityIn.getMoveLog().getMoves().get(tileEntityIn.getMoveLog().getMoves().size() - 1);
                        for (BaseMove move : this.pieceLegalMoves(tileEntityIn)) {
                            this.destinationCoordinates.add(move.getDestinationCoordinate());
                        }
                        if (!(lastMove.getCurrentCoordinate() != currentCoordinate || this.destinationCoordinates.contains(lastMove.getCurrentCoordinate()) && tileEntityIn.getShowAvailableMoves())) {
                            this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.LAST_MADE_MOVE, tileEntityIn);
                        }
                        if (!(lastMove.getDestinationCoordinate() != currentCoordinate || this.destinationCoordinates.contains(lastMove.getDestinationCoordinate()) && tileEntityIn.getShowAvailableMoves())) {
                            this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.LAST_MADE_MOVE, tileEntityIn);
                        }
                        this.destinationCoordinates.clear();
                    }
                    if (!(tileEntityIn.getHumanMovedPiece() == null || tileEntityIn.getHumanMovedPiece().getPieceColor() != tileEntityIn.getBoard().getCurrentChessPlayer().getPieceColor() || tileEntityIn.getCachedPiece() != null && tileEntityIn.getCachedPiece().equals(tileEntityIn.getHumanMovedPiece()))) {
                        tileEntityIn.clearMoveTransitionsCache();
                        for (BaseMove move : this.pieceLegalMoves(tileEntityIn)) {
                            MoveTransition transition = board.getCurrentChessPlayer().makeMove(move);
                            tileEntityIn.addToMoveTransitionsCache(transition);
                        }
                        tileEntityIn.setCachedPiece(tileEntityIn.getHumanMovedPiece());
                    }
                    if (tileEntityIn.getShowAvailableMoves()) {
                        block20: for (int i = 0; i < this.pieceLegalMoves(tileEntityIn).size(); ++i) {
                            MoveTransition transition;
                            BaseMove move;
                            if (tileEntityIn.getMoveTransitionsCache().isEmpty() || (move = (transition = tileEntityIn.getMoveTransitionsCache().get(i)).getMove()).getDestinationCoordinate() != currentCoordinate) continue;
                            if (move.isCastlingMove()) {
                                this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.CASTLE_MOVE, tileEntityIn);
                                continue;
                            }
                            switch (transition.getMoveStatus()) {
                                case DONE: {
                                    this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, move.isAttack() ? HighlightType.ATTACK_MOVE : HighlightType.LEGAL_MOVE, tileEntityIn);
                                    continue block20;
                                }
                                case LEAVES_PLAYER_IN_CHECK: {
                                    this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.LEAVES_PLAYER_IN_CHECK, tileEntityIn);
                                }
                            }
                        }
                    }
                    poseStack.m_85849_();
                }
            }
            poseStack.m_85849_();
        }
    }

    private void renderTakenPieces(PoseStack stack, MultiBufferSource buffer, ChessBlockEntity chessBlockEntity, int packedLight) {
        ChessMoveLog moveLog = chessBlockEntity.getMoveLog();
        for (BaseMove move : moveLog.getMoves()) {
            if (!move.isAttack()) continue;
            BasePiece takenPiece = move.getAttackedPiece();
            if (takenPiece.getPieceColor().isWhite()) {
                this.whiteTakenPieces.add(takenPiece);
                continue;
            }
            if (takenPiece.getPieceColor().isBlack()) {
                this.blackTakenPieces.add(takenPiece);
                continue;
            }
            throw new RuntimeException("Attempted to get a Piece that had no PieceColor");
        }
        this.whiteTakenPieces.sort((piece1, piece2) -> Ints.compare((int)piece2.getPieceValue(), (int)piece1.getPieceValue()));
        this.blackTakenPieces.sort((piece1, piece2) -> Ints.compare((int)piece2.getPieceValue(), (int)piece1.getPieceValue()));
        this.renderTakenPiecesFigures(stack, buffer, chessBlockEntity, this.whiteTakenPieces, true, packedLight);
        this.renderTakenPiecesFigures(stack, buffer, chessBlockEntity, this.blackTakenPieces, false, packedLight);
        this.whiteTakenPieces.clear();
        this.blackTakenPieces.clear();
    }

    private void renderTakenPiecesFigures(PoseStack stack, MultiBufferSource buffer, ChessBlockEntity chessBlockEntity, List<BasePiece> pieceList, boolean isWhite, int packedLight) {
        int currentCoordinate = -1;
        int currentRank = 0;
        float wR = (float)NBTColorSaving.getRed(chessBlockEntity.getWhitePiecesColor()) / 255.0f;
        float wG = (float)NBTColorSaving.getGreen(chessBlockEntity.getWhitePiecesColor()) / 255.0f;
        float wB = (float)NBTColorSaving.getBlue(chessBlockEntity.getWhitePiecesColor()) / 255.0f;
        float bR = (float)NBTColorSaving.getRed(chessBlockEntity.getBlackPiecesColor()) / 255.0f;
        float bG = (float)NBTColorSaving.getGreen(chessBlockEntity.getBlackPiecesColor()) / 255.0f;
        float bB = (float)NBTColorSaving.getBlue(chessBlockEntity.getBlackPiecesColor()) / 255.0f;
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)SHADER_COMPAT_WHITE));
        BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(chessBlockEntity.getPieceSet() + 1);
        for (BasePiece piece : pieceList) {
            if (currentCoordinate < 7) {
                ++currentCoordinate;
            } else {
                currentCoordinate = 0;
                ++currentRank;
            }
            stack.m_85836_();
            if (isWhite) {
                stack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
            }
            if (!isWhite) {
                stack.m_85837_(0.7481249999999999, 0.0, 0.75);
            }
            stack.m_85837_(0.106875 * (double)(-currentCoordinate), 0.0, (double)(0.125f * (float)(-currentRank)));
            if (ShaderCompatHandler.isShaderActive()) {
                DrawScreenHelper.CHESS_PIECE_MODEL.render(stack, consumer, piece.getPieceType(), set, isWhite ? wR : bR, isWhite ? wG : bG, isWhite ? wB : bB, packedLight);
            } else {
                this.renderPiece(stack, chessBlockEntity.getPieceSet(), piece.getPieceType(), piece.getPieceColor(), wR, wG, wB, bR, bG, bB);
            }
            stack.m_85849_();
        }
    }

    private void renderPiece(PoseStack poseStack, int pieceModelSet, BasePiece.PieceType pieceType, PieceColor pieceColor, float wR, float wG, float wB, float bR, float bG, float bB) {
        ShaderInstance shaderinstance = RenderSystem.getShader();
        BufferHelpers.updateColor(shaderinstance, new float[]{pieceColor.isWhite() ? wR : bR, pieceColor.isWhite() ? wG : bG, pieceColor.isWhite() ? wB : bB, 1.0f});
        poseStack.m_85836_();
        if (shaderinstance.f_173308_ != null) {
            shaderinstance.f_173308_.m_5679_(poseStack.m_85850_().m_252922_());
        }
        BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(pieceModelSet + 1);
        VertexBuffer pawnBuffer = DrawScreenHelper.getBuffer(set, pieceType);
        BufferHelpers.draw(pawnBuffer);
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private Collection<BaseMove> pieceLegalMoves(ChessBlockEntity chessBlockEntity) {
        if (chessBlockEntity.getHumanMovedPiece() != null && chessBlockEntity.getHumanMovedPiece().getPieceColor() == chessBlockEntity.getBoard().getCurrentChessPlayer().getPieceColor()) {
            ArrayList<BaseMove> pieceMoves = new ArrayList<BaseMove>();
            for (BaseMove move : chessBlockEntity.getBoard().getCurrentChessPlayer().getLegalMoves()) {
                if (move.getMovedPiece() != chessBlockEntity.getHumanMovedPiece()) continue;
                pieceMoves.add(move);
            }
            return ImmutableList.copyOf(pieceMoves);
        }
        return Collections.emptyList();
    }

    private void renderHighlight(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, HighlightType highlightType, ChessBlockEntity chessBlockEntity) {
        VertexConsumer builderHighlight = bufferIn.m_6299_(TTCRenderTypes.getEmissiveTransluscent(HIGHLIGHT_TEXTURE, false));
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, -1.345f, 0.0f);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        poseStack.m_85850_().m_252943_().rotationZYX(0.0f, (float)Math.PI, 0.0f);
        switch (highlightType) {
            default: {
                float R = (float)NBTColorSaving.getRed(chessBlockEntity.getLegalMoveColor()) / 255.0f;
                float G = (float)NBTColorSaving.getGreen(chessBlockEntity.getLegalMoveColor()) / 255.0f;
                float B = (float)NBTColorSaving.getBlue(chessBlockEntity.getLegalMoveColor()) / 255.0f;
                float A = (float)NBTColorSaving.getAlpha(chessBlockEntity.getLegalMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R, G, B, A);
                break;
            }
            case LEAVES_PLAYER_IN_CHECK: {
                float R1 = (float)NBTColorSaving.getRed(chessBlockEntity.getInvalidMoveColor()) / 255.0f;
                float G1 = (float)NBTColorSaving.getGreen(chessBlockEntity.getInvalidMoveColor()) / 255.0f;
                float B1 = (float)NBTColorSaving.getBlue(chessBlockEntity.getInvalidMoveColor()) / 255.0f;
                float A1 = (float)NBTColorSaving.getAlpha(chessBlockEntity.getInvalidMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R1, G1, B1, A1);
                break;
            }
            case CASTLE_MOVE: {
                float R2 = (float)NBTColorSaving.getRed(chessBlockEntity.getCastleMoveColor()) / 255.0f;
                float G2 = (float)NBTColorSaving.getGreen(chessBlockEntity.getCastleMoveColor()) / 255.0f;
                float B2 = (float)NBTColorSaving.getBlue(chessBlockEntity.getCastleMoveColor()) / 255.0f;
                float A2 = (float)NBTColorSaving.getAlpha(chessBlockEntity.getCastleMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R2, G2, B2, A2);
                break;
            }
            case ATTACK_MOVE: {
                float R3 = (float)NBTColorSaving.getRed(chessBlockEntity.getAttackMoveColor()) / 255.0f;
                float G3 = (float)NBTColorSaving.getGreen(chessBlockEntity.getAttackMoveColor()) / 255.0f;
                float B3 = (float)NBTColorSaving.getBlue(chessBlockEntity.getAttackMoveColor()) / 255.0f;
                float A3 = (float)NBTColorSaving.getAlpha(chessBlockEntity.getAttackMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R3, G3, B3, A3);
                break;
            }
            case LAST_MADE_MOVE: {
                float R4 = (float)NBTColorSaving.getRed(chessBlockEntity.getPreviousMoveColor()) / 255.0f;
                float G4 = (float)NBTColorSaving.getGreen(chessBlockEntity.getPreviousMoveColor()) / 255.0f;
                float B4 = (float)NBTColorSaving.getBlue(chessBlockEntity.getPreviousMoveColor()) / 255.0f;
                float A4 = (float)NBTColorSaving.getAlpha(chessBlockEntity.getPreviousMoveColor()) / 255.0f;
                this.highlightModel.m_7695_(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R4, G4, B4, A4);
            }
        }
        poseStack.m_85849_();
    }

    private void renderTilesInfo(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ChessBlockEntity chessBlockEntity) {
        VertexConsumer builderTilesInfo = bufferIn.m_6299_(TTCRenderTypes.getEmissiveTransluscent(TILES_INFO_TEXTURE, false));
        float red = (float)NBTColorSaving.getRed(chessBlockEntity.getTileInfoColor()) / 255.0f;
        float green = (float)NBTColorSaving.getGreen(chessBlockEntity.getTileInfoColor()) / 255.0f;
        float blue = (float)NBTColorSaving.getBlue(chessBlockEntity.getTileInfoColor()) / 255.0f;
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
        poseStack.m_252880_(0.0f, -1.32f, 0.0f);
        poseStack.m_85850_().m_252943_().rotationZYX(0.0f, (float)Math.PI, 0.0f);
        this.tilesInfoModel.m_7695_(poseStack, builderTilesInfo, combinedLightIn, combinedOverlayIn, red, green, blue, 1.0f);
        poseStack.m_85849_();
    }

    private void renderChessBoardPlate(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ChessBlockEntity chessBlockEntity) {
        float whiteR = (float)NBTColorSaving.getRed(chessBlockEntity.getWhiteTilesColor()) / 255.0f;
        float whiteG = (float)NBTColorSaving.getGreen(chessBlockEntity.getWhiteTilesColor()) / 255.0f;
        float whiteB = (float)NBTColorSaving.getBlue(chessBlockEntity.getWhiteTilesColor()) / 255.0f;
        float blackR = (float)NBTColorSaving.getRed(chessBlockEntity.getBlackTilesColor()) / 255.0f;
        float blackG = (float)NBTColorSaving.getGreen(chessBlockEntity.getBlackTilesColor()) / 255.0f;
        float blackB = (float)NBTColorSaving.getBlue(chessBlockEntity.getBlackTilesColor()) / 255.0f;
        VertexConsumer builderBoardPlateWhiteTiles = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)PLATE_WHITE_TILES_TEXTURE));
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252392_.m_252977_(270.0f));
        poseStack.m_85837_(0.0, -1.65, 0.0);
        this.chessBoardPlateModel.m_7695_(poseStack, builderBoardPlateWhiteTiles, combinedLightIn, combinedOverlayIn, whiteR, whiteG, whiteB, 1.0f);
        poseStack.m_85849_();
        VertexConsumer builderBoardPlateBlackTiles = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)PLATE_BLACK_TILES_TEXTURE));
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252392_.m_252977_(270.0f));
        poseStack.m_85837_(0.0, -1.65, 0.0);
        this.chessBoardPlateModel.m_7695_(poseStack, builderBoardPlateBlackTiles, combinedLightIn, combinedOverlayIn, blackR, blackG, blackB, 1.0f);
        poseStack.m_85849_();
    }

    static {
        image.m_84988_(0, 0, 0xFFFFFF);
        texture.m_117985_();
        resourceLocation = Minecraft.m_91087_().m_91097_().m_118490_("table_top_craft_dummy", texture);
    }

    static enum HighlightType {
        LEGAL_MOVE,
        LEAVES_PLAYER_IN_CHECK,
        CASTLE_MOVE,
        ATTACK_MOVE,
        LAST_MADE_MOVE;

    }
}

