/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.animation.system.core;

import andrews.table_top_craft.animation.model.AdvancedModelPart;
import andrews.table_top_craft.animation.model.IAnimatedModel;
import andrews.table_top_craft.animation.system.core.AdvancedAnimationState;
import andrews.table_top_craft.animation.system.core.Animation;
import andrews.table_top_craft.animation.system.core.BasicKeyframe;
import andrews.table_top_craft.animation.system.core.KeyframeGroup;
import andrews.table_top_craft.animation.system.core.types.EasingTypes;
import andrews.table_top_craft.animation.system.core.types.util.EasingMath;
import andrews.table_top_craft.animation.system.core.types.util.EasingType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class AnimationHandler {
    public static void animate(IAnimatedModel model, AdvancedAnimationState state, Vector3f animationVecCache) {
        Animation animation = state.getAnimation();
        float elapsedSeconds = AnimationHandler.getElapsedSeconds(state);
        if (state.getOutTime() != 0.0f) {
            elapsedSeconds = state.getPrevElapsedTime();
        }
        int entries = animation.getKeyframeGroups().entrySet().size();
        for (Map.Entry<String, List<KeyframeGroup>> map : animation.getKeyframeGroups().entrySet()) {
            Object object;
            --entries;
            List<KeyframeGroup> keyframeGroupList = map.getValue();
            Optional<ModelPart> modelPartOptional = model.getAnyDescendantWithName(map.getKey());
            if (!modelPartOptional.isPresent() || !((object = modelPartOptional.get()) instanceof AdvancedModelPart)) continue;
            AdvancedModelPart modelPart = (AdvancedModelPart)((Object)object);
            object = keyframeGroupList.iterator();
            while (object.hasNext()) {
                float modifier;
                float time;
                KeyframeGroup keyframeGroup = (KeyframeGroup)object.next();
                BasicKeyframe[] keyframes = keyframeGroup.getKeyframes();
                if (state.getOutTime() == 0.0f) {
                    AnimationHandler.processIdxCache(state, keyframeGroupList, keyframeGroup, keyframes, entries, elapsedSeconds);
                }
                int currentKeyframeIdx = state.cachedIndex.get(keyframeGroup);
                int lastKeyframeIdx = Math.max(0, currentKeyframeIdx - 1);
                BasicKeyframe currentKeyframe = keyframes[currentKeyframeIdx];
                BasicKeyframe lastKeyframe = keyframes[lastKeyframeIdx];
                float timeStampMod = state.getInTime();
                float elapsedDelta = elapsedSeconds - (lastKeyframe.timestamp() + timeStampMod);
                float keyframeDelta = Mth.m_14036_((float)(elapsedDelta / (currentKeyframe.timestamp() + timeStampMod - (lastKeyframe.timestamp() + timeStampMod))), (float)0.0f, (float)1.0f);
                if (Float.isNaN(keyframeDelta)) {
                    keyframeDelta = 0.0f;
                }
                float actualElapsed = AnimationHandler.getElapsedSeconds(state);
                float targetTime = state.forceOutLinear() ? elapsedSeconds : actualElapsed;
                float lastTargetTime = AnimationHandler.getLastTargetTime(state, elapsedSeconds, actualElapsed);
                currentKeyframe.getEasingType().storeEasedValues(animationVecCache, keyframeDelta, keyframes, lastKeyframe.target(lastTargetTime), currentKeyframeIdx, targetTime);
                float interpolFactor = 1.0f;
                if (state.getInTime() != 0.0f) {
                    time = state.getInTime();
                    modifier = 1.0f - (1.0f - Math.min(time, elapsedSeconds) / time);
                    if (state.getEaseInType() != null) {
                        modifier = AnimationHandler.applyEasing(state.getEaseInType(), modifier);
                    }
                    interpolFactor = modifier;
                }
                if (state.getOutTime() != 0.0f) {
                    time = state.getOutTime();
                    modifier = 1.0f - (1.0f - (1.0f - Math.min(time, actualElapsed - elapsedSeconds) / time));
                    if (state.getEaseOutType() != null) {
                        modifier = AnimationHandler.applyEasing(state.getEaseOutType(), modifier);
                    }
                    interpolFactor *= modifier;
                }
                keyframeGroup.getTransformType().applyValues(modelPart, animationVecCache.mul(interpolFactor));
                if (state.getOutTime() == 0.0f || interpolFactor != 0.0f || entries > 0 || !AnimationHandler.isLastTransformType(keyframeGroup, keyframeGroupList)) continue;
                state.m_216973_();
            }
        }
    }

    public static float getElapsedSeconds(AdvancedAnimationState state) {
        float accumulatedSeconds = (float)state.m_216981_() / 1000.0f;
        float animLength = state.getAnimation().getLengthInSeconds() + state.getInTime() + state.getOutTime();
        return state.getAnimation().isLooping() ? accumulatedSeconds % animLength : accumulatedSeconds;
    }

    private static void processIdxCache(AdvancedAnimationState state, List<KeyframeGroup> keyframeGroupList, KeyframeGroup keyframeGroup, BasicKeyframe[] keyframes, int entries, float elapsedSeconds) {
        Animation animation = state.getAnimation();
        float animLength = animation.getLengthInSeconds() + state.getInTime() + state.getOutTime();
        if (!state.cachedIndex.containsKey(keyframeGroup)) {
            state.cachedIndex.put(keyframeGroup, 0);
        }
        if ((float)state.m_216981_() >= animLength * 1000.0f && animation.isLooping()) {
            state.cachedIndex.put(keyframeGroup, 0);
            if (entries <= 0 && AnimationHandler.isLastTransformType(keyframeGroup, keyframeGroupList)) {
                state.f_216971_ = (long)((float)state.f_216971_ - animLength * 1000.0f);
                if (!state.keepEasingIn() && state.getInTime() != 0.0f) {
                    state.resetInTime();
                }
            }
        }
        float timeStampMod = state.getInTime();
        if (keyframes[state.cachedIndex.get(keyframeGroup)].timestamp() + timeStampMod <= elapsedSeconds) {
            state.cachedIndex.put(keyframeGroup, Math.min(keyframes.length - 1, state.cachedIndex.get(keyframeGroup) + 1));
        }
    }

    private static boolean isLastTransformType(KeyframeGroup keyframeGroup, List<KeyframeGroup> keyframeGroupList) {
        if (keyframeGroupList.size() == 1) {
            return true;
        }
        int maxPriority = keyframeGroupList.stream().mapToInt(kg -> kg.getTransformType().getPriority()).max().orElse(0);
        return keyframeGroup.getTransformType().getPriority() == maxPriority;
    }

    private static float getLastTargetTime(AdvancedAnimationState state, float elapsedSeconds, float actualElapsed) {
        if (state.forceInLinear() && state.forceOutLinear()) {
            return state.getInTime();
        }
        if (!state.forceInLinear() && state.forceOutLinear()) {
            return state.getOutTime() != 0.0f ? elapsedSeconds : actualElapsed;
        }
        if (state.forceInLinear() && !state.forceOutLinear()) {
            return state.getOutTime() != 0.0f ? actualElapsed - (elapsedSeconds - state.getInTime()) : state.getInTime();
        }
        return actualElapsed;
    }

    private static float applyEasing(EasingTypes type, float value) {
        return switch (type.getEasingType()) {
            default -> value;
            case EasingType.STEPS -> EasingMath.easeSteps(value, type.getOptionalValue());
            case EasingType.EASE_IN_SINE -> EasingMath.easeInSine(value);
            case EasingType.EASE_OUT_SINE -> EasingMath.easeOutSine(value);
            case EasingType.EASE_IN_OUT_SINE -> EasingMath.easeInOutSine(value);
            case EasingType.EASE_IN_QUAD -> EasingMath.easeInQuad(value);
            case EasingType.EASE_OUT_QUAD -> EasingMath.easeOutQuad(value);
            case EasingType.EASE_IN_OUT_QUAD -> EasingMath.easeInOutQuad(value);
            case EasingType.EASE_IN_CUBIC -> EasingMath.easeInCubic(value);
            case EasingType.EASE_OUT_CUBIC -> EasingMath.easeOutCubic(value);
            case EasingType.EASE_IN_OUT_CUBIC -> EasingMath.easeInOutCubic(value);
            case EasingType.EASE_IN_QUART -> EasingMath.easeInQuart(value);
            case EasingType.EASE_OUT_QUART -> EasingMath.easeOutQuart(value);
            case EasingType.EASE_IN_OUT_QUART -> EasingMath.easeInOutQuart(value);
            case EasingType.EASE_IN_QUINT -> EasingMath.easeInQuint(value);
            case EasingType.EASE_OUT_QUINT -> EasingMath.easeOutQuint(value);
            case EasingType.EASE_IN_OUT_QUINT -> EasingMath.easeInOutQuint(value);
            case EasingType.EASE_IN_EXPO -> EasingMath.easeInExpo(value);
            case EasingType.EASE_OUT_EXPO -> EasingMath.easeOutExpo(value);
            case EasingType.EASE_IN_OUT_EXPO -> EasingMath.easeInOutExpo(value);
            case EasingType.EASE_IN_CIRC -> EasingMath.easeInCirc(value);
            case EasingType.EASE_OUT_CIRC -> EasingMath.easeOutCirc(value);
            case EasingType.EASE_IN_OUT_CIRC -> EasingMath.easeInOutCirc(value);
            case EasingType.EASE_IN_BACK -> EasingMath.easeInBack(value, type.getOptionalValue());
            case EasingType.EASE_OUT_BACK -> EasingMath.easeOutBack(value, type.getOptionalValue());
            case EasingType.EASE_IN_OUT_BACK -> EasingMath.easeInOutBack(value, type.getOptionalValue());
            case EasingType.EASE_IN_ELASTIC -> EasingMath.easeInElastic(value, type.getOptionalValue());
            case EasingType.EASE_OUT_ELASTIC -> EasingMath.easeOutElastic(value, type.getOptionalValue());
            case EasingType.EASE_IN_OUT_ELASTIC -> EasingMath.easeInOutElastic(value, type.getOptionalValue());
            case EasingType.EASE_IN_BOUNCE -> EasingMath.easeInBounce(value, type.getOptionalValue());
            case EasingType.EASE_OUT_BOUNCE -> EasingMath.easeOutBounce(value, type.getOptionalValue());
            case EasingType.EASE_IN_OUT_BOUNCE -> EasingMath.easeInOutBounce(value, type.getOptionalValue());
        };
    }
}

