/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui;

import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SelectionListEntry
extends ContainerObjectSelectionList.Entry<SelectionListEntry> {
    private final Component title;
    private final List<FormattedCharSequence> tooltip;
    private final List<AbstractWidget> widgets;

    public SelectionListEntry(Component title, List<FormattedCharSequence> tooltip, List<AbstractWidget> widgets) {
        this.title = title;
        this.tooltip = tooltip;
        this.widgets = widgets;
    }

    public void m_6311_(GuiGraphics graphics, int i, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        for (AbstractWidget widget : this.widgets) {
            widget.m_253211_(y);
            widget.m_88315_(graphics, mouseX, mouseY, delta);
        }
        this.renderTitle(graphics, y, 12, x + width / 2 - 10);
    }

    private void renderTitle(GuiGraphics graphics, int minY, int minX, int maxX) {
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.title);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int y = minY + 9 / 2 + 1;
        int width = maxX - minX;
        if (textWidth > width) {
            int difference = textWidth - width;
            double nanos = (double)Util.m_137550_() / 1000.0;
            double e = Math.max((double)difference * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * nanos / e)) / 2.0 + 0.5;
            double g = Mth.m_14139_((double)f, (double)0.0, (double)difference);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            graphics.m_280588_(minX, minY, maxX, minY + 9 * 2);
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, this.title, minX - (int)g, y, 0xFFFFFF);
            graphics.m_280618_();
        } else {
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, this.title, minX, y, 0xFFFFFF);
        }
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    @NotNull
    public List<? extends NarratableEntry> m_142437_() {
        return this.widgets;
    }

    public List<FormattedCharSequence> getTooltip() {
        return this.tooltip;
    }
}

