/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.BulletRenderer;
import ewewukek.musketmod.ClientUtilities;
import ewewukek.musketmod.ClothConfigScreen;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.MusketMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.PacketListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.NetworkEvent;

public class ClientSetup {
    public ClientSetup(IEventBus bus) {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> ClothConfigScreen.build(parent)));
        bus.addListener(this::setup);
        bus.addListener(this::registerRenderers);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, this::renderHand);
    }

    public void setup(FMLClientSetupEvent event) {
        ClientUtilities.registerItemProperties();
    }

    public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(BulletEntity.ENTITY_TYPE, BulletRenderer::new);
    }

    public void renderHand(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && stack.m_41720_() instanceof GunItem) {
            Minecraft mc = Minecraft.m_91087_();
            ClientUtilities.renderGunInHand(mc.m_91290_().m_234586_(), (AbstractClientPlayer)mc.f_91074_, event.getHand(), event.getPartialTick(), event.getInterpolatedPitch(), event.getSwingProgress(), event.getEquipProgress(), stack, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
            event.setCanceled(true);
        }
    }

    public static void handleSmokeEffectPacket(MusketMod.SmokeEffectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        PacketListener listener = ctx.get().getNetworkManager().m_129538_();
        if (listener instanceof ClientPacketListener) {
            GunItem.fireParticles((Level)((ClientPacketListener)listener).m_105147_(), packet.origin, packet.direction);
        }
    }
}

