/*
 * Decompiled with CFR 0.152.
 */
package org.filip.botaniatubes;

import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;

public class PetalApothecaryFluidHandler
implements IFluidHandler {
    private final PetalApothecaryBlockEntity apothecaryEntity;

    public PetalApothecaryFluidHandler(PetalApothecaryBlockEntity apothecaryEntity) {
        this.apothecaryEntity = apothecaryEntity;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        FlowingFluid fluid = switch (this.apothecaryEntity.getFluid()) {
            case PetalApothecary.State.WATER -> Fluids.f_76193_;
            case PetalApothecary.State.LAVA -> Fluids.f_76195_;
            default -> Fluids.f_76191_;
        };
        return fluid != Fluids.f_76191_ ? new FluidStack((Fluid)fluid, 1000) : FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return stack.getFluid() == Fluids.f_76193_ || stack.getFluid() == Fluids.f_76195_;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.apothecaryEntity.getFluid() != PetalApothecary.State.EMPTY) {
            return 0;
        }
        if (resource.getFluid() == Fluids.f_76193_) {
            if (action.execute()) {
                this.apothecaryEntity.setFluid(PetalApothecary.State.WATER);
            }
            return 1000;
        }
        if (resource.getFluid() == Fluids.f_76195_) {
            if (action.execute()) {
                this.apothecaryEntity.setFluid(PetalApothecary.State.LAVA);
            }
            return 1000;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        Fluid currentFluid = this.getFluidInTank(0).getFluid();
        if (resource.getFluid() != currentFluid) {
            return FluidStack.EMPTY;
        }
        return this.drain(1000, action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Fluid currentFluid = this.getFluidInTank(0).getFluid();
        if (currentFluid == Fluids.f_76191_ || maxDrain < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack drained = new FluidStack(currentFluid, 1000);
        if (action.execute()) {
            this.apothecaryEntity.setFluid(PetalApothecary.State.EMPTY);
        }
        return drained;
    }
}

