/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.redstoneRequester;

import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiParticle;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterEffectPacket;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterMenu;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;

public class RedstoneRequesterBlockEntity
extends StockCheckingBlockEntity
implements MenuProvider {
    public boolean allowPartialRequests = false;
    public PackageOrderWithCrafts encodedRequest = PackageOrderWithCrafts.empty();
    public String encodedTargetAdress = "";
    public boolean lastRequestSucceeded;
    protected boolean redstonePowered;

    public RedstoneRequesterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void onRedstonePowerChanged() {
        boolean hasNeighborSignal = this.f_58857_.m_276867_(this.f_58858_);
        if (this.redstonePowered == hasNeighborSignal) {
            return;
        }
        this.lastRequestSucceeded = false;
        if (hasNeighborSignal) {
            this.triggerRequest();
        }
        this.redstonePowered = hasNeighborSignal;
        this.notifyUpdate();
    }

    public void triggerRequest() {
        if (this.encodedRequest.isEmpty()) {
            return;
        }
        boolean anySucceeded = false;
        InventorySummary summaryOfOrder = new InventorySummary();
        this.encodedRequest.stacks().forEach(summaryOfOrder::add);
        InventorySummary summary = this.getAccurateSummary();
        for (BigItemStack entry : summaryOfOrder.getStacks()) {
            if (summary.getCountOf(entry.stack) >= entry.count) {
                anySucceeded = true;
                continue;
            }
            if (this.allowPartialRequests) continue;
            AllPackets.sendToNear(this.f_58857_, this.f_58858_, 32, new RedstoneRequesterEffectPacket(this.f_58858_, false));
            return;
        }
        this.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.REDSTONE, this.encodedRequest, null, this.encodedTargetAdress);
        AllPackets.sendToNear(this.f_58857_, this.f_58858_, 32, new RedstoneRequesterEffectPacket(this.f_58858_, anySucceeded));
        this.lastRequestSucceeded = true;
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.redstonePowered = tag.m_128471_("Powered");
        this.lastRequestSucceeded = tag.m_128471_("Success");
        this.allowPartialRequests = tag.m_128471_("AllowPartial");
        this.encodedRequest = PackageOrderWithCrafts.read(tag.m_128469_("EncodedRequest"));
        this.encodedTargetAdress = tag.m_128461_("EncodedAddress");
    }

    @Override
    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        tag.m_128379_("AllowPartial", this.allowPartialRequests);
        tag.m_128359_("EncodedAddress", this.encodedTargetAdress);
        tag.m_128365_("EncodedRequest", (Tag)this.encodedRequest.write());
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("Powered", this.redstonePowered);
        tag.m_128379_("Success", this.lastRequestSucceeded);
        tag.m_128379_("AllowPartial", this.allowPartialRequests);
        tag.m_128359_("EncodedAddress", this.encodedTargetAdress);
        tag.m_128365_("EncodedRequest", (Tag)this.encodedRequest.write());
    }

    public InteractionResult use(Player player) {
        if (player == null || player.m_6047_()) {
            return InteractionResult.PASS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        if (this.f_58857_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!this.behaviour.mayInteractMessage(player)) {
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        return InteractionResult.SUCCESS;
    }

    public Component m_5446_() {
        return Component.m_237119_();
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return RedstoneRequesterMenu.create(pContainerId, pPlayerInventory, this);
    }

    public void playEffect(boolean success) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)this.f_58858_);
        if (success) {
            AllSoundEvents.CONFIRM.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.5f, 1.5f, false);
            AllSoundEvents.STOCK_LINK.playAt(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 1.0f, false);
            this.f_58857_.m_7106_((ParticleOptions)new WiFiParticle.Data(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0, 1.0, 1.0);
        } else {
            AllSoundEvents.DENY.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.5f, 1.0f, false);
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123808_, vec3.f_82479_, vec3.f_82480_ + 1.0, vec3.f_82481_, 0.0, 0.0, 0.0);
        }
    }
}

