/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packager;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;

public class PackagerBlock
extends WrenchableDirectionalBlock
implements IBE<PackagerBlockEntity>,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty LINKED = BooleanProperty.m_61465_((String)"linked");

    public PackagerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState defaultBlockState = this.m_49966_();
        if (defaultBlockState.m_61138_((Property)LINKED)) {
            defaultBlockState = (BlockState)defaultBlockState.m_61124_((Property)LINKED, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_((BlockState)defaultBlockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Capability itemCap = ForgeCapabilities.ITEM_HANDLER;
        Direction preferredFacing = null;
        for (Direction face : context.m_6232_()) {
            BlockEntity be = context.m_43725_().m_7702_(context.m_8083_().m_121945_(face));
            if (be instanceof PackagerBlockEntity || be == null || !be.getCapability(itemCap).isPresent()) continue;
            preferredFacing = face.m_122424_();
            break;
        }
        Player player = context.m_43723_();
        if (preferredFacing == null) {
            Direction facing = context.m_7820_();
            Direction direction = preferredFacing = player != null && player.m_6144_() ? facing : facing.m_122424_();
        }
        if (player != null && !(player instanceof FakePlayer) && AllBlocks.PORTABLE_STORAGE_INTERFACE.has(context.m_43725_().m_8055_(context.m_8083_().m_121945_(preferredFacing.m_122424_())))) {
            CreateLang.translate("packager.no_portable_storage", new Object[0]).sendStatus(player);
            return null;
        }
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())))).m_61124_((Property)f_52588_, (Comparable)preferredFacing);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack itemInHand = player.m_21120_(handIn);
        if (AllItems.WRENCH.isIn(itemInHand)) {
            return InteractionResult.PASS;
        }
        if (AllBlocks.FACTORY_GAUGE.isIn(itemInHand)) {
            return InteractionResult.PASS;
        }
        if (!(!AllBlocks.STOCK_LINK.isIn(itemInHand) || state.m_61138_((Property)LINKED) && ((Boolean)state.m_61143_((Property)LINKED)).booleanValue())) {
            return InteractionResult.PASS;
        }
        if (AllBlocks.PACKAGE_FROGPORT.isIn(itemInHand)) {
            return InteractionResult.PASS;
        }
        if (this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            if (be.heldBox.m_41619_()) {
                if (be.animationTicks > 0) {
                    return InteractionResult.SUCCESS;
                }
                if (PackageItem.isPackage(itemInHand)) {
                    if (worldIn.m_5776_()) {
                        return InteractionResult.SUCCESS;
                    }
                    if (!be.unwrapBox(itemInHand.m_41777_(), true)) {
                        return InteractionResult.SUCCESS;
                    }
                    be.unwrapBox(itemInHand.m_41777_(), false);
                    be.triggerStockCheck();
                    itemInHand.m_41774_(1);
                    AllSoundEvents.DEPOT_PLOP.playOnServer(worldIn, (Vec3i)pos);
                    if (itemInHand.m_41619_()) {
                        player.m_21008_(handIn, ItemStack.f_41583_);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.SUCCESS;
            }
            if (be.animationTicks > 0) {
                return InteractionResult.SUCCESS;
            }
            if (!worldIn.m_5776_()) {
                player.m_150109_().m_150079_(be.heldBox.m_41777_());
                AllSoundEvents.playItemPickup(player);
                be.heldBox = ItemStack.f_41583_;
                be.notifyUpdate();
            }
            return InteractionResult.SUCCESS;
        }).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{POWERED, LINKED}));
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        if (neighbor.m_121945_(state.m_61145_((Property)f_52588_).orElse(Direction.UP)).equals((Object)pos)) {
            this.withBlockEntityDo((BlockGetter)level, pos, PackagerBlockEntity::triggerStockCheck);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered == worldIn.m_276867_(pos)) {
            return;
        }
        worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        if (!previouslyPowered) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, PackagerBlockEntity::activate);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        IBE.onRemove(pState, pLevel, pPos, pNewState);
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    public Class<PackagerBlockEntity> getBlockEntityClass() {
        return PackagerBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends PackagerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.PACKAGER.get();
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return this.getBlockEntityOptional((BlockGetter)pLevel, pPos).map(pbe -> {
            boolean empty = pbe.inventory.getStackInSlot(0).m_41619_();
            if (pbe.animationTicks != 0) {
                empty = false;
            }
            return empty ? 0 : 15;
        }).orElse(0);
    }
}

