/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LevelLoadingScreen.class})
public class LevelLoadingScreenMixin {
    @Mutable
    @Shadow
    @Final
    private static Object2IntMap<ChunkStatus> f_96140_;
    @Unique
    private static Reference2IntOpenHashMap<ChunkStatus> STATUS_TO_COLOR_FAST;
    @Unique
    private static final int NULL_STATUS_COLOR;
    @Unique
    private static final int DEFAULT_STATUS_COLOR;

    @Overwrite
    public static void m_96149_(GuiGraphics drawContext, StoringChunkProgressListener tracker, int mapX, int mapY, int mapScale, int mapPadding) {
        if (STATUS_TO_COLOR_FAST == null) {
            STATUS_TO_COLOR_FAST = new Reference2IntOpenHashMap(f_96140_.size());
            STATUS_TO_COLOR_FAST.put(null, NULL_STATUS_COLOR);
            f_96140_.object2IntEntrySet().forEach(entry -> STATUS_TO_COLOR_FAST.put((Object)((ChunkStatus)entry.getKey()), ColorARGB.toABGR(entry.getIntValue(), 255)));
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = drawContext.m_280168_().m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
        int centerSize = tracker.m_9672_();
        int size = tracker.m_9673_();
        int tileSize = mapScale + mapPadding;
        if (mapPadding != 0) {
            int mapRenderCenterSize = centerSize * tileSize - mapPadding;
            int radius = mapRenderCenterSize / 2 + 1;
            LevelLoadingScreenMixin.addRect(writer, matrix, mapX - radius, mapY - radius, mapX - radius + 1, mapY + radius, DEFAULT_STATUS_COLOR);
            LevelLoadingScreenMixin.addRect(writer, matrix, mapX + radius - 1, mapY - radius, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
            LevelLoadingScreenMixin.addRect(writer, matrix, mapX - radius, mapY - radius, mapX + radius, mapY - radius + 1, DEFAULT_STATUS_COLOR);
            LevelLoadingScreenMixin.addRect(writer, matrix, mapX - radius, mapY + radius - 1, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
        }
        int mapRenderSize = size * tileSize - mapPadding;
        int mapStartX = mapX - mapRenderSize / 2;
        int mapStartY = mapY - mapRenderSize / 2;
        ChunkStatus prevStatus = null;
        int prevColor = NULL_STATUS_COLOR;
        for (int x = 0; x < size; ++x) {
            int tileX = mapStartX + x * tileSize;
            for (int z = 0; z < size; ++z) {
                int color;
                int tileY = mapStartY + z * tileSize;
                ChunkStatus status = tracker.m_9663_(x, z);
                if (prevStatus == status) {
                    color = prevColor;
                } else {
                    color = STATUS_TO_COLOR_FAST.getInt((Object)status);
                    prevStatus = status;
                    prevColor = color;
                }
                LevelLoadingScreenMixin.addRect(writer, matrix, tileX, tileY, tileX + mapScale, tileY + mapScale, color);
            }
        }
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    @Unique
    private static void addRect(VertexBufferWriter writer, Matrix4f matrix, int x1, int y1, int x2, int y2, int color) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(64);
            ColorVertex.put(ptr, matrix, x1, y2, 0.0f, color);
            ColorVertex.put(ptr += 16L, matrix, x2, y2, 0.0f, color);
            ColorVertex.put(ptr += 16L, matrix, x2, y1, 0.0f, color);
            ColorVertex.put(ptr += 16L, matrix, x1, y1, 0.0f, color);
            ptr += 16L;
            writer.push(stack, buffer, 4, ColorVertex.FORMAT);
        }
    }

    static {
        NULL_STATUS_COLOR = ColorABGR.pack(0, 0, 0, 255);
        DEFAULT_STATUS_COLOR = ColorARGB.pack(0, 17, 255, 255);
    }
}

