/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.blockofsky.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import java.io.IOException;
import net.cerulan.blockofsky.BlockOfSkyMod;
import net.cerulan.blockofsky.client.LevelRendererBOS;
import net.cerulan.blockofsky.client.SkyBlockEntityRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class BOSClient {
    private static ShaderInstance skyShader;
    private static int skyWidth;
    private static int skyHeight;
    private static TextureTarget skyRenderTarget;
    public static boolean updateSky;
    private static boolean isRenderingSky;
    public static final RenderType SKY_RENDER_TYPE;

    public static void init() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockOfSkyMod.SKY_BE_TYPE.get()), SkyBlockEntityRenderer::new);
        ClientReloadShadersEvent.EVENT.register((resource, uwu) -> {
            try {
                uwu.registerShader(new ShaderInstance(resource, "blockofsky_sky", DefaultVertexFormat.f_85814_), BOSClient::setSkyShader);
            }
            catch (IOException ex) {
                System.err.println("Failed to load shader");
                ex.printStackTrace();
            }
        });
    }

    public static ShaderInstance getSkyShader() {
        return skyShader;
    }

    public static void setSkyShader(ShaderInstance shader) {
        skyShader = shader;
    }

    private static void setSkyTexture() {
        if (skyRenderTarget != null) {
            RenderSystem.setShaderTexture((int)0, (int)skyRenderTarget.m_83975_());
        } else {
            RenderSystem.setShaderTexture((int)0, (int)0);
        }
    }

    public static void renderSky(RenderData renderData) {
        if (isRenderingSky) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        int ww = window.m_85441_();
        int wh = window.m_85442_();
        if (ww <= 0 || wh <= 0) {
            return;
        }
        boolean update = false;
        if (skyRenderTarget == null || skyWidth != ww || skyHeight != wh) {
            update = true;
            skyWidth = ww;
            skyHeight = wh;
        }
        if (update) {
            if (skyRenderTarget != null) {
                skyRenderTarget.m_83930_();
            }
            skyRenderTarget = new TextureTarget(skyWidth, skyHeight, true, Minecraft.f_91002_);
        }
        mc.f_91063_.m_172775_(false);
        mc.f_91060_.m_173014_();
        skyRenderTarget.m_83947_(true);
        isRenderingSky = true;
        RenderTarget mainRenderTarget = mc.m_91385_();
        BOSClient.renderActualSky(mc, renderData);
        isRenderingSky = false;
        mc.f_91063_.m_172775_(true);
        skyRenderTarget.m_83963_();
        skyRenderTarget.m_83970_();
        mc.f_91060_.m_173014_();
        mainRenderTarget.m_83947_(true);
    }

    public static void renderActualSky(Minecraft mc, RenderData renderData) {
        if (mc == null || mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        PoseStack poseStack = renderData.poseStack();
        float delta = renderData.partialTick();
        Matrix4f projectionMatrix = renderData.projectionMatrix();
        LevelRenderer levelRenderer = mc.f_91060_;
        LevelRendererBOS levelRendererBOS = (LevelRendererBOS)levelRenderer;
        GameRenderer gameRenderer = mc.f_91063_;
        Camera camera = gameRenderer.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        LightTexture lightTexture = gameRenderer.m_109154_();
        FogRenderer.m_109018_((Camera)camera, (float)delta, (ClientLevel)mc.f_91073_, (int)mc.f_91066_.m_193772_(), (float)gameRenderer.m_109131_(delta));
        FogRenderer.m_109036_();
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        float renderDistance = gameRenderer.m_109152_();
        boolean hasSpecialFog = mc.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)cameraPos.f_82479_), Mth.m_14107_((double)cameraPos.f_82481_)) || mc.f_91065_.m_93090_().m_93715_();
        FogRenderer.m_234172_((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)renderDistance, (boolean)hasSpecialFog, (float)delta);
        RenderSystem.setShader(GameRenderer::m_172808_);
        levelRenderer.m_202423_(poseStack, projectionMatrix, delta, camera, false, () -> FogRenderer.m_234172_((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)renderDistance, (boolean)hasSpecialFog, (float)delta));
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        if (mc.f_91066_.m_92174_() != CloudStatus.OFF) {
            RenderSystem.setShader(GameRenderer::m_172838_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            levelRenderer.m_253054_(poseStack, projectionMatrix, delta, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
        }
        RenderSystem.depthMask((boolean)false);
        levelRendererBOS.BOS$renderSnowAndRain(lightTexture, delta, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        FogRenderer.m_109017_();
    }

    static {
        skyWidth = -1;
        skyHeight = -1;
        updateSky = false;
        isRenderingSky = false;
        SKY_RENDER_TYPE = RenderType.m_173215_((String)"blockofsky_sky", (VertexFormat)DefaultVertexFormat.f_85814_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(BOSClient::getSkyShader)).m_173290_(new RenderStateShard.EmptyTextureStateShard(BOSClient::setSkyTexture, () -> {})).m_110691_(false));
    }

    public record RenderData(PoseStack poseStack, float partialTick, Matrix4f projectionMatrix) {
    }
}

