/*
 * Decompiled with CFR 0.152.
 */
package net.cerulan.blockofsky;

import net.cerulan.blockofsky.SkyBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class SkyBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    protected SkyBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new SkyBlockEntity(SkyBlockEntity.SkyType.Overworld, blockPos, blockState);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean powered = ctx.m_43725_().m_276867_(ctx.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(!powered));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkyBlockEntity) {
            SkyBlockEntity skyBlockEntity = (SkyBlockEntity)blockEntity;
            skyBlockEntity.neighborChanged();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, level, pos, block, fromPos, notify);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkyBlockEntity) {
            SkyBlockEntity skyBlockEntity = (SkyBlockEntity)blockEntity;
            skyBlockEntity.neighborChanged();
        }
        if (!level.f_46443_) {
            boolean hasSignal = level.m_276867_(pos);
            if ((Boolean)state.m_61143_((Property)ACTIVE) == hasSignal) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(!hasSignal)), 2);
            }
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 0;
    }

    public RenderShape m_7514_(BlockState state) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
    }

    public static class VoidBlock
    extends SkyBlock {
        @Override
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return new SkyBlockEntity(SkyBlockEntity.SkyType.Void, blockPos, blockState);
        }

        @Override
        public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
            if (state.m_60804_(world, pos)) {
                return world.m_7469_();
            }
            return state.m_60631_(world, pos) ? 0 : 1;
        }
    }
}

