/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.results;

import com.almostreliable.lootjs.LootJSPlatform;
import com.almostreliable.lootjs.LootModificationsAPI;
import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.loot.results.Info;
import com.almostreliable.lootjs.loot.results.LootInfoCollector;
import com.almostreliable.lootjs.util.LootContextUtils;
import com.almostreliable.lootjs.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LootContextInfo {
    LootInfoCollector collector = new LootInfoCollector();

    private LootContextInfo() {
    }

    @Nullable
    public static LootContextInfo create(LootContext context) {
        if (!LootModificationsAPI.LOOT_MODIFICATION_LOGGING) {
            return null;
        }
        LootContextInfo lci = new LootContextInfo();
        lci.add("LootTable", Utils.quote(LootJSPlatform.INSTANCE.getQueriedLootTableId(context)));
        ILootContextData data = (ILootContextData)context.m_78953_(LootJSParamSets.DATA);
        if (data != null) {
            lci.add("LootType", data.getLootContextType().name());
            lci.updateLoot(data.getGeneratedLoot());
        }
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        lci.addOptional("Position", origin, Utils::formatPosition);
        lci.addOptional("Block", (BlockState)context.m_78953_(LootContextParams.f_81461_));
        lci.addOptional("Explosion", (Float)context.m_78953_(LootContextParams.f_81464_));
        lci.addOptional("Entity", (Entity)context.m_78953_(LootContextParams.f_81455_), Utils::formatEntity);
        lci.addOptional("Killer Entity", (Entity)context.m_78953_(LootContextParams.f_81458_), Utils::formatEntity);
        lci.addOptional("Direct Killer", (Entity)context.m_78953_(LootContextParams.f_81459_), Utils::formatEntity);
        ServerPlayer player = LootContextUtils.getPlayerOrNull(context);
        if (player != null) {
            lci.addOptional("Player", player, Utils::formatEntity);
            lci.addOptional("Player Pos", player.m_20182_(), Utils::formatPosition);
            if (origin != null) {
                lci.addOptional("Distance", String.format("%.2f", player.m_20182_().m_82554_(origin)));
            }
            lci.addItem("MainHand", player.m_6844_(EquipmentSlot.MAINHAND));
            lci.addItem("OffHand", player.m_6844_(EquipmentSlot.OFFHAND));
            lci.addItem("Head", player.m_6844_(EquipmentSlot.HEAD));
            lci.addItem("Chest", player.m_6844_(EquipmentSlot.CHEST));
            lci.addItem("Legs", player.m_6844_(EquipmentSlot.LEGS));
            lci.addItem("Feet", player.m_6844_(EquipmentSlot.FEET));
        }
        return lci;
    }

    private void add(String left, String right) {
        this.collector.addOrPush(new Info.RowInfo(left, right));
    }

    private <T> void addOptional(String left, @Nullable T t, Function<T, String> formatter) {
        if (t == null) {
            return;
        }
        this.add(left, formatter.apply(t));
    }

    private <T> void addOptional(String left, @Nullable T t) {
        if (t == null) {
            return;
        }
        this.add(left, t.toString());
    }

    private void addItem(String left, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        this.add(left, Utils.formatItemStack(itemStack));
    }

    public void updateLoot(Collection<ItemStack> loot) {
        LootComposite lootComposite = this.collector.getFirstLayer().stream().filter(LootComposite.class::isInstance).findFirst().orElse(null);
        if (lootComposite == null) {
            LootComposite lc = new LootComposite();
            this.collector.add(lc);
            this.updateLoot(loot, lc.getBefore());
        } else {
            this.updateLoot(loot, lootComposite.getAfter());
        }
    }

    private void updateLoot(Collection<ItemStack> loot, Info.Composite composite) {
        for (ItemStack itemStack : loot) {
            composite.addChildren(new Info.TitledInfo(Utils.formatItemStack(itemStack)));
        }
    }

    public LootInfoCollector getCollector() {
        return this.collector;
    }

    public static class LootComposite
    extends Info.Composite {
        private final Info.Composite before = new Info.Composite("Before");
        private final Info.Composite after = new Info.Composite("After");

        public LootComposite() {
            super("Loot");
            this.children.add(this.before);
            this.children.add(this.after);
        }

        @Override
        public void addChildren(Info info) {
            throw new UnsupportedOperationException("LootComposite cannot add custom children");
        }

        @Override
        public Collection<Info> getChildren() {
            ArrayList<Info> c = new ArrayList<Info>();
            c.add(this.before.getChildren().isEmpty() ? new Info.TitledInfo("before {}") : this.before);
            c.add(this.after.getChildren().isEmpty() ? new Info.TitledInfo("after {}") : this.after);
            return c;
        }

        public Info.Composite getBefore() {
            return this.before;
        }

        public Info.Composite getAfter() {
            return this.after;
        }
    }
}

