/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.event;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.advancement.PlayerSleepInfo;
import io.github.mortuusars.chalk.config.Config;
import io.github.mortuusars.chalk.core.MarkSymbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chalk", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerForgeEvents {
    @SubscribeEvent
    public static void advancementProgress(AdvancementEvent.AdvancementProgressEvent event) {
        Advancement advancement = event.getAdvancement();
        if (advancement == null || event.getProgressType() == AdvancementEvent.AdvancementProgressEvent.ProgressType.REVOKE || !event.getAdvancementProgress().m_8193_()) {
            return;
        }
        ResourceLocation id = advancement.m_138327_();
        for (Map.Entry<MarkSymbol, Pair<ForgeConfigSpec.BooleanValue, ForgeConfigSpec.ConfigValue<String>>> entry : Config.SYMBOL_CONFIG.entrySet()) {
            Player player;
            boolean isEnabled = (Boolean)((ForgeConfigSpec.BooleanValue)entry.getValue().getFirst()).get();
            String location = (String)((ForgeConfigSpec.ConfigValue)entry.getValue().getSecond()).get();
            if (!isEnabled || location.isEmpty() || !location.equals(id.toString()) || !((player = event.getEntity()) instanceof ServerPlayer)) continue;
            ServerPlayer player2 = (ServerPlayer)player;
            player2.m_5661_((Component)Component.m_237110_((String)"gui.chalk.unlocked_symbol_message", (Object[])new Object[]{Component.m_237115_((String)entry.getKey().getTranslationKey()).m_130948_(Style.f_131099_.m_178520_(5481951))}), false);
            player2.m_6330_((SoundEvent)Chalk.SoundEvents.MARK_DRAW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
    }

    @SubscribeEvent
    public static void onSleepFinished(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            Optional sleepingPos;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean sleepingLongEnough = serverPlayer.m_36317_();
            if (!sleepingLongEnough) {
                return;
            }
            List tags = serverPlayer.m_19880_().stream().toList();
            ArrayList<BlockPos> sleepPositions = new ArrayList<BlockPos>();
            for (String tag : tags) {
                if (!tag.startsWith("PlayerSleepInfo")) continue;
                serverPlayer.m_20137_(tag);
                String dataStr = tag.replace("PlayerSleepInfo", "");
                PlayerSleepInfo sleepInfo = PlayerSleepInfo.deserialize(dataStr);
                sleepPositions = new ArrayList<BlockPos>(sleepInfo.sleepPositions());
                break;
            }
            if ((sleepingPos = serverPlayer.m_21257_()).isPresent()) {
                if (sleepPositions.size() > 20) {
                    sleepPositions.remove(0);
                }
                sleepPositions.add((BlockPos)sleepingPos.get());
                PlayerSleepInfo sleepInfo = new PlayerSleepInfo(sleepPositions);
                Chalk.CriteriaTriggers.CONSECUTIVE_SLEEPING.trigger(serverPlayer, sleepInfo);
                String serializedDataStr = sleepInfo.serialize();
                serverPlayer.m_20049_("PlayerSleepInfo" + serializedDataStr);
            }
        }
    }
}

