/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.advancement.PlayerSleepInfo;
import java.util.List;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class ConsecutiveSleepingTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final ResourceLocation ID = Chalk.resource("consecutive_sleeping_pos");

    @NotNull
    protected TriggerInstance createInstance(JsonObject json, ContextAwarePredicate predicate, @NotNull DeserializationContext conditionsParser) {
        return new TriggerInstance(predicate, MinMaxBounds.Ints.m_55373_((JsonElement)json.get("count")), DistancePredicate.m_26264_((JsonElement)json.get("distance")));
    }

    public void trigger(ServerPlayer player, PlayerSleepInfo sleepInfo) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(player, sleepInfo));
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints count;
        private final DistancePredicate distance;

        public TriggerInstance(ContextAwarePredicate predicate, MinMaxBounds.Ints count, DistancePredicate distance) {
            super(ID, predicate);
            this.count = count;
            this.distance = distance;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext conditions) {
            JsonObject jsonObject = super.m_7683_(conditions);
            jsonObject.add("count", this.count.m_55328_());
            jsonObject.add("distance", this.distance.m_26254_());
            return jsonObject;
        }

        public boolean matches(ServerPlayer player, PlayerSleepInfo sleepInfo) {
            List<BlockPos> sleepPositions = sleepInfo.sleepPositions();
            if (sleepPositions.isEmpty()) {
                return false;
            }
            if (sleepPositions.size() == 1) {
                return this.count.m_55390_(1);
            }
            BlockPos lastSleepPos = sleepPositions.get(sleepPositions.size() - 1);
            int matchedDistanceCount = 1;
            for (int i = sleepPositions.size() - 2; i >= 0; --i) {
                BlockPos pos = sleepPositions.get(i);
                if (!this.distance.m_26255_((double)lastSleepPos.m_123341_(), (double)lastSleepPos.m_123342_(), (double)lastSleepPos.m_123343_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) break;
                ++matchedDistanceCount;
            }
            return this.count.m_55390_(matchedDistanceCount);
        }
    }
}

