/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.ETFException;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.property_reading.RandomPropertyRule;
import traben.entity_texture_features.features.property_reading.properties.RandomProperties;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.SimpleIntegerArrayProperty;
import traben.entity_texture_features.features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.EntityBooleanLRU;

public class PropertiesRandomProvider
implements ETFApi.ETFVariantSuffixProvider {
    protected final List<RandomPropertyRule> propertyRules;
    protected final EntityBooleanLRU entityCanUpdate = new EntityBooleanLRU(1000);
    @NotNull
    protected final String packname;
    protected ETFApi.ETFVariantSuffixProvider.EntityRandomSeedFunction entityRandomSeedFunction = ETFEntity::etf$getOptifineId;
    protected BiConsumer<ETFEntity, @Nullable RandomPropertyRule> onMeetsRule = (entity, rule) -> {};

    private PropertiesRandomProvider(ResourceLocation propertiesFileIdentifier, List<RandomPropertyRule> propertyRules) {
        this.propertyRules = propertyRules;
        this.packname = Minecraft.m_91087_().m_91098_().m_213713_(propertiesFileIdentifier).map(Resource::m_215506_).orElse("vanilla");
    }

    @Nullable
    public static PropertiesRandomProvider of(ResourceLocation initialPropertiesFileIdentifier, ResourceLocation vanillaIdentifier, String ... suffixKeyName) {
        ResourceLocation propertiesFileIdentifier = ETFDirectory.getDirectoryVersionOf(initialPropertiesFileIdentifier);
        if (propertiesFileIdentifier == null) {
            return null;
        }
        try {
            List<RandomPropertyRule> propertyRules;
            Properties props = ETFUtils2.readAndReturnPropertiesElseNull(propertiesFileIdentifier);
            if (props == null) {
                ETFUtils2.logMessage("Ignoring properties file that was null @ " + String.valueOf(propertiesFileIdentifier), false);
                return null;
            }
            if (vanillaIdentifier.m_135815_().endsWith(".png")) {
                ETFManager.getInstance().grabSpecialProperties(props, ETFRenderContext.getCurrentEntity());
            }
            if ((propertyRules = PropertiesRandomProvider.getAllValidPropertyObjects(props, propertiesFileIdentifier, suffixKeyName)).isEmpty()) {
                ETFUtils2.logMessage("Ignoring properties file that failed to load any cases @ " + String.valueOf(propertiesFileIdentifier), false);
                return null;
            }
            if (!propertyRules.get(propertyRules.size() - 1).isAlwaysMet()) {
                propertyRules.add(RandomPropertyRule.defaultReturn);
            }
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            String properties = resourceManager.m_213713_(propertiesFileIdentifier).map(Resource::m_215506_).orElse(null);
            String vanillaPack = resourceManager.m_213713_(vanillaIdentifier).map(Resource::m_215506_).orElse(null);
            if (properties != null && properties.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(properties, vanillaPack))) {
                return new PropertiesRandomProvider(propertiesFileIdentifier, propertyRules);
            }
        }
        catch (ETFException etf) {
            if (!propertiesFileIdentifier.toString().contains("optifine/cit/")) {
                ETFUtils2.logWarn("Ignoring properties file with problem: " + String.valueOf(propertiesFileIdentifier) + "\n" + String.valueOf(etf), false);
            }
        }
        catch (Exception e) {
            ETFUtils2.logWarn("Ignoring properties file that caused unexpected Exception: " + String.valueOf(propertiesFileIdentifier) + "\n" + String.valueOf(e), false);
            e.printStackTrace();
        }
        return null;
    }

    public static List<RandomPropertyRule> getAllValidPropertyObjects(Properties properties, ResourceLocation propertiesFilePath, String ... suffixToTest) throws ETFException {
        Set<String> propIds = properties.stringPropertyNames();
        List<Integer> numbersList = PropertiesRandomProvider.getCaseNumbers(propIds);
        Collections.sort(numbersList);
        if (numbersList.isEmpty()) {
            ETFUtils2.logWarn("Properties file [" + String.valueOf(propertiesFilePath) + "] contains no rules, this is invalid.", false);
            throw new ETFException("Properties file [" + String.valueOf(propertiesFilePath) + "] contains no rules, this is invalid.");
        }
        if (numbersList.get(0) < 1) {
            ETFUtils2.logWarn("Properties file [" + String.valueOf(propertiesFilePath) + "] contains rule numbers less than 1, this is invalid.", false);
            throw new ETFException("Properties file [" + String.valueOf(propertiesFilePath) + "] contains rule numbers less than 1, this is invalid.");
        }
        int last = 0;
        for (Integer i : numbersList) {
            if (i >= last + 10) {
                last = -1;
                break;
            }
            last = i;
        }
        if (last == -1) {
            if (ETF.config().getConfig().optifine_limitRandomVariantGapsBy10) {
                ETFUtils2.logError("Properties file [" + String.valueOf(propertiesFilePath) + "] has skipped rule numbers by values greater than 10, this is invalid in OptiFine. This limitation can be disabled in ETF's settings, but will make your pack incompatible with OptiFine.", false);
                throw new ETFException("Properties file [" + String.valueOf(propertiesFilePath) + "] has skipped rule numbers by values greater than 10, this is invalid in OptiFine. This limitation can be disabled in ETF's settings, but will make your pack incompatible with OptiFine.");
            }
            ETFUtils2.logWarn("Properties file [" + String.valueOf(propertiesFilePath) + "] has skipped rule numbers by values greater than 10, this is invalid in OptiFine. This limitation has been disabled in ETF's settings, your pack is incompatible with OptiFine.", false);
        }
        ArrayList<RandomPropertyRule> allRulesOfProperty = new ArrayList<RandomPropertyRule>();
        for (Integer ruleNumber : numbersList) {
            Integer[] suffixesOfRule = PropertiesRandomProvider.getSuffixes(properties, ruleNumber, suffixToTest);
            if (suffixesOfRule != null && suffixesOfRule.length != 0) {
                allRulesOfProperty.add(new RandomPropertyRule(propertiesFilePath.toString(), ruleNumber, suffixesOfRule, PropertiesRandomProvider.getWeights(properties, ruleNumber), RandomProperties.getAllRegisteredRandomPropertiesOfIndex(properties, ruleNumber)));
                continue;
            }
            ETFUtils2.logWarn("property number \"" + ruleNumber + ". in file \"" + String.valueOf(propertiesFilePath) + ". failed to read.");
        }
        return allRulesOfProperty;
    }

    @NotNull
    private static List<Integer> getCaseNumbers(Set<String> propIds) {
        HashSet<Integer> foundRuleNumbers = new HashSet<Integer>();
        for (String str : propIds) {
            String possibleRuleNumber;
            String[] split = str.split("\\.");
            if (split.length < 2 || split[1].isBlank() || (possibleRuleNumber = split[1].replaceAll("\\D", "")).isBlank()) continue;
            try {
                foundRuleNumbers.add(Integer.parseInt(possibleRuleNumber));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new ArrayList<Integer>(foundRuleNumbers);
    }

    @Nullable
    private static Integer[] getSuffixes(Properties props, int num, String ... suffixToTest) throws ETFException {
        Object[] suffixes = SimpleIntegerArrayProperty.getGenericIntegerSplitWithRanges(props, num, suffixToTest);
        if (suffixes != null) {
            for (Integer n : suffixes) {
                if (n >= 1) continue;
                throw new ETFException("Invalid suffix: [" + n + "] in " + Arrays.toString(suffixes));
            }
        }
        return suffixes;
    }

    @Nullable
    private static Integer[] getWeights(Properties props, int num) {
        return SimpleIntegerArrayProperty.getGenericIntegerSplitWithRanges(props, num, "weights");
    }

    public void setOnMeetsRuleHook(BiConsumer<ETFEntity, RandomPropertyRule> onMeetsRule) {
        if (onMeetsRule != null) {
            this.onMeetsRule = onMeetsRule;
        }
    }

    @NotNull
    public String getPackName() {
        return this.packname;
    }

    public boolean isHigherPackThan(@Nullable String packNameOther) {
        return this.packname.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(this.packname, packNameOther));
    }

    @Override
    public boolean entityCanUpdate(UUID uuid) {
        return this.entityCanUpdate.getBoolean(uuid);
    }

    @Override
    public IntOpenHashSet getAllSuffixes() {
        IntOpenHashSet allSuffixes = new IntOpenHashSet();
        for (RandomPropertyRule rule : this.propertyRules) {
            allSuffixes.addAll(rule.getSuffixSet());
        }
        return allSuffixes;
    }

    @Override
    public int size() {
        return this.propertyRules.size();
    }

    @Override
    public int getSuffixForETFEntity(ETFEntity entityToBeTested) {
        if (entityToBeTested == null) {
            return 0;
        }
        UUID id = entityToBeTested.etf$getUuid();
        boolean entityHasBeenTestedBefore = this.entityCanUpdate.containsKey(id);
        int result = this.testEntityAgainstRules(entityToBeTested, entityHasBeenTestedBefore);
        if (!entityHasBeenTestedBefore && this.entityCanUpdate.getBoolean(id)) {
            for (RandomPropertyRule rule : this.propertyRules) {
                rule.cacheEntityInitialResultsOfNonUpdatingProperties(entityToBeTested);
            }
        }
        if (result > 0) {
            return result;
        }
        this.onMeetsRule.accept(entityToBeTested, null);
        return 0;
    }

    private int testEntityAgainstRules(ETFEntity entityToBeTested, boolean isUpdate) {
        for (RandomPropertyRule rule : this.propertyRules) {
            if (!rule.doesEntityMeetConditionsOfThisCase(entityToBeTested, isUpdate, this.entityCanUpdate)) continue;
            this.onMeetsRule.accept(entityToBeTested, rule);
            return rule.getVariantSuffixFromThisCase(this.entityRandomSeedFunction.toInt(entityToBeTested));
        }
        return 0;
    }

    @Override
    public void setRandomSupplier(ETFApi.ETFVariantSuffixProvider.EntityRandomSeedFunction entityRandomSeedFunction) {
        if (entityRandomSeedFunction != null) {
            this.entityRandomSeedFunction = entityRandomSeedFunction;
        }
    }
}

