/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinTool;
import traben.entity_texture_features.config.screens.skin.ETFScreenOldCompat;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolPixelSelection
extends ETFScreenOldCompat {
    private final SelectionMode MODE;
    private final ETFConfigScreenSkinTool etfParent;
    Set<Integer> selectedPixels;
    ResourceLocation currentSkinToRender = ETFUtils2.res("entity_texture_features:textures/gui/icon.png");

    protected ETFConfigScreenSkinToolPixelSelection(ETFConfigScreenSkinTool parent, SelectionMode mode) {
        super("config.entity_texture_features" + (mode == SelectionMode.EMISSIVE ? ".emissive_select" : ".enchanted_select") + ".title", parent, false);
        this.MODE = mode;
        this.etfParent = parent;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        ResourceLocation randomID = ETFUtils2.res("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
        if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID)) {
            this.currentSkinToRender = randomID;
        }
        this.selectedPixels = new HashSet<Integer>();
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                int color = ETFUtils2.getPixel(this.etfParent.currentEditorSkin, x, y);
                if (color == 0) continue;
                this.selectedPixels.add(color);
            }
        }
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.024), (int)((double)this.f_96544_ * 0.2), 20, 20, Component.m_130674_((String)"\u27f3"), button -> {
            this.etfParent.flipView = !this.etfParent.flipView;
        }));
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.55), (int)((double)this.f_96544_ * 0.9), (int)((double)this.f_96543_ * 0.2), 20, CommonComponents.f_130660_, button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parent)));
        int pixelSize = (int)((double)this.f_96544_ * 0.7 / 64.0);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                Button butt = this.getButtonPixels(x, y, pixelSize);
                this.m_142416_((GuiEventListener)butt);
            }
        }
    }

    @NotNull
    private Button getButtonPixels(int x, int y, int pixelSize) {
        return new Button((int)((double)this.f_96543_ * 0.35 + (double)(x * pixelSize)), (int)((double)this.f_96544_ * 0.2 + (double)(y * pixelSize)), pixelSize, pixelSize, Component.m_130674_((String)""), button -> {
            int colorAtPixel = ETFUtils2.getPixel(this.etfParent.currentEditorSkin, x, y);
            if (this.selectedPixels.contains(colorAtPixel)) {
                this.selectedPixels.remove(colorAtPixel);
            } else {
                this.selectedPixels.add(colorAtPixel);
            }
            this.applyCurrentSelectedPixels();
            this.etfParent.thisETFPlayerTexture.changeSkinToThisForTool(this.etfParent.currentEditorSkin);
            ResourceLocation randomID2 = ETFUtils2.res("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
            if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID2)) {
                this.currentSkinToRender = randomID2;
            }
        }, Supplier::get){

            protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            }
        };
    }

    private void applyCurrentSelectedPixels() {
        ArrayList<Integer> integerSet = new ArrayList<Integer>(this.selectedPixels);
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                if (integerSet.isEmpty()) {
                    ETFUtils2.setPixel(this.etfParent.currentEditorSkin, x, y, 0);
                    continue;
                }
                ETFUtils2.setPixel(this.etfParent.currentEditorSkin, x, y, integerSet.get(0));
                integerSet.remove(0);
            }
        }
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        int pixelSize = (int)((double)this.f_96544_ * 0.7 / 64.0);
        ETFConfigScreenSkinToolPixelSelection.renderGUITexture(context, this.currentSkinToRender, (int)((double)this.f_96543_ * 0.35), (int)((double)this.f_96544_ * 0.2), (int)((double)this.f_96543_ * 0.35 + (double)(64 * pixelSize)), (int)((double)this.f_96544_ * 0.2 + (double)(64 * pixelSize)));
        context.m_280430_(this.f_96547_, ETF.getTextFromTranslation("config.entity_texture_features.skin_select" + (this.selectedPixels.size() > 64 ? ".warn" : ".hint")), this.f_96543_ / 7, (int)((double)this.f_96544_ * 0.8), this.selectedPixels.size() > 64 ? 0xFF1515 : 0xFFFFFF);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            int height = (int)((double)this.f_96544_ * 0.75);
            int playerX = (int)((double)this.f_96543_ * 0.14);
            this.drawEntity(context, playerX, height, (int)((double)this.f_96544_ * 0.3), -mouseX + playerX, (float)((double)(-mouseY) + (double)this.f_96544_ * 0.3), (LivingEntity)player);
        } else {
            context.m_280430_(this.f_96547_, Component.m_130674_((String)"Player model only visible while in game!"), this.f_96543_ / 7, (int)((double)this.f_96544_ * 0.4), 0xFFFFFF);
            context.m_280430_(this.f_96547_, Component.m_130674_((String)"load a single-player world and then open this menu."), this.f_96543_ / 7, (int)((double)this.f_96544_ * 0.45), 0xFFFFFF);
        }
    }

    public void drawEntity(GuiGraphics context, int x, int y, int size, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(0.0f);
        quaternionf.mul((Quaternionfc)quaternionf2);
        context.m_280168_().m_85836_();
        context.m_280168_().m_85837_((double)x, (double)y, 150.0);
        context.m_280168_().m_252931_(new Matrix4f().scaling((float)size, (float)size, (float)(-size)));
        context.m_280168_().m_252781_(quaternionf);
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        if (quaternionf2 != null) {
            quaternionf2.conjugate();
            entityRenderDispatcher.m_252923_(quaternionf2);
        }
        entityRenderDispatcher.m_114468_(false);
        float h = entity.f_20883_;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity.f_20886_;
        float l = entity.f_20885_;
        entity.f_20883_ = (this.etfParent.flipView ? 0.0f : 180.0f) + f * 20.0f;
        entity.m_146922_((this.etfParent.flipView ? 0.0f : 180.0f) + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.m_280168_(), (MultiBufferSource)context.m_280091_(), LightTexture.m_109885_((int)7, (int)7)));
        context.m_280262_();
        entityRenderDispatcher.m_114468_(true);
        context.m_280168_().m_85849_();
        Lighting.m_84931_();
        entity.f_20883_ = h;
        entity.m_146922_(i);
        entity.m_146926_(j);
        entity.f_20886_ = k;
        entity.f_20885_ = l;
    }

    public static enum SelectionMode {
        EMISSIVE(56, 16),
        ENCHANTED(56, 24);

        final int startX;
        final int startY;

        private SelectionMode(int start_x, int start_y) {
            this.startX = start_x;
            this.startY = start_y;
        }
    }
}

