/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.value;

import java.lang.reflect.Field;
import mod.azure.azurelib.config.ConfigUtils;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.config.format.IConfigFormat;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.config.value.IntegerValue;
import mod.azure.azurelib.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public final class IntValue
extends IntegerValue<Integer> {
    public IntValue(ValueData<Integer> valueData) {
        super(valueData, IntegerValue.Range.unboundedInt());
    }

    @Override
    public Integer getCorrectedValue(Integer in) {
        if (this.range == null) {
            return in;
        }
        if (!this.range.isWithin(in.intValue())) {
            int corrected = this.range.clamp(in);
            ConfigUtils.logCorrectedMessage(this.getId(), in, corrected);
            return corrected;
        }
        return in;
    }

    @Override
    public void serialize(IConfigFormat format) {
        format.writeInt(this.getId(), (Integer)this.get());
    }

    @Override
    public void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(format.readInt(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) {
            return new IntValue(ValueData.of(name, Integer.valueOf((Integer)value), context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            buffer.writeInt(((Integer)value.get()).intValue());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            return buffer.readInt();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setInt(instance, (Integer)value);
        }
    }
}

