/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.extensions.PackExtension;
import com.supermartijn642.fusion.resources.FusionPackMetadata;
import com.supermartijn642.fusion.resources.ResourcePackListTipRenderer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TransferableSelectionList.PackEntry.class})
public class PackEntryMixin {
    @Final
    @Shadow
    private PackSelectionModel.Entry f_100078_;
    @Final
    @Shadow
    private TransferableSelectionList f_100077_;
    @Unique
    private FusionPackMetadata metadata;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void cacheFusionMetadata(CallbackInfo ci) {
        if (this.f_100078_ instanceof PackSelectionModel.EntryBase) {
            this.metadata = ((PackExtension)((PackSelectionModel.EntryBase)this.f_100078_).f_99933_).getFusionMetadata();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V", shift=At.Shift.BEFORE, ordinal=0)})
    private void renderBackground(GuiGraphics graphics, int entryIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks, CallbackInfo ci) {
        if (this.metadata == null) {
            return;
        }
        if (this.f_100077_.m_93518_() > 0) {
            width -= 7;
        }
        ResourcePackListTipRenderer.renderBackground(this.metadata, this.f_100078_.m_7709_().m_10489_(), graphics, left, top, width, height);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V", shift=At.Shift.AFTER, ordinal=0)})
    private void renderIcon(GuiGraphics graphics, int entryIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks, CallbackInfo ci) {
        if (this.metadata == null) {
            return;
        }
        if (this.f_100077_.m_93518_() > 0) {
            width -= 7;
        }
        ResourcePackListTipRenderer.renderIcon(this.metadata, this.f_100078_.m_7709_().m_10489_(), graphics, left, top, width, height);
    }

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/packs/PackSelectionModel$Entry;canSelect()Z", shift=At.Shift.BEFORE))
    private MultiLineLabel adjustDescription(MultiLineLabel label) {
        if (this.metadata == null) {
            return label;
        }
        Component warningMessage = ResourcePackListTipRenderer.getWarningMessage(this.metadata, this.f_100078_.m_7709_().m_10489_());
        return warningMessage == null ? label : MultiLineLabel.m_94345_((Font)Minecraft.m_91087_().f_91062_, (FormattedText)warningMessage, (int)157, (int)2);
    }

    @Inject(method={"handlePackSelection"}, at={@At(value="HEAD")}, cancellable=true)
    private void showFusionWarningScreen(CallbackInfoReturnable<Boolean> ci) {
        if (this.metadata == null) {
            return;
        }
        Consumer<Boolean> callback = select -> {
            Minecraft.m_91087_().m_91152_((Screen)this.f_100077_.f_263433_);
            if (select.booleanValue()) {
                this.f_100078_.m_7849_();
            }
        };
        if (ResourcePackListTipRenderer.showWarningScreen(this.metadata, this.f_100078_.m_7709_().m_10489_(), (PackSelectionModel.EntryBase)this.f_100078_, callback)) {
            ci.setReturnValue((Object)false);
        }
    }
}

