/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.create.platform;

import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.simibubi.create.api.effect.OpenPipeEffectHandler;
import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.create.events.SpecialFluidHandlerEvent;
import dev.latvian.mods.kubejs.create.events.SpecialSpoutHandlerEvent;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;

public class FluidIngredientHelper {
    public static FluidIngredient toFluidIngredient(FluidStackJS fluidStack) {
        return FluidIngredient.fromFluidStack((net.minecraftforge.fluids.FluidStack)FluidStackHooksForge.toForge((FluidStack)fluidStack.getFluidStack()));
    }

    public static SimpleRegistry.Provider<Fluid, OpenPipeEffectHandler> createEffectHandler(final FluidIngredient fluidIngredient, final SpecialFluidHandlerEvent.PipeHandler handler) {
        return new SimpleRegistry.Provider<Fluid, OpenPipeEffectHandler>(){
            final FluidIngredient filter;
            Set<Fluid> validFluids;
            final OpenPipeEffectHandler internalHandler;
            {
                this.filter = fluidIngredient;
                this.validFluids = null;
                this.internalHandler = (level, aabb, fluid) -> {
                    if (this.filter.test(fluid)) {
                        handler.apply(level, aabb, FluidStackJS.of((Object)fluid));
                    }
                };
            }

            @Nullable
            public OpenPipeEffectHandler get(Fluid fluidIn) {
                if (this.validFluids.contains(fluidIn)) {
                    return this.internalHandler;
                }
                return null;
            }

            private Set<Fluid> getValidFluids() {
                if (this.validFluids == null) {
                    HashSet<Fluid> set = new HashSet<Fluid>();
                    for (net.minecraftforge.fluids.FluidStack fluidStack : fluidIngredient.getMatchingFluidStacks()) {
                        Fluid fluid = fluidStack.getFluid();
                        set.add(fluid);
                    }
                    this.validFluids = set;
                }
                return this.validFluids;
            }

            public void onRegister(Runnable invalidate) {
                MinecraftForge.EVENT_BUS.addListener(event -> {
                    if (event.shouldUpdateStaticData()) {
                        invalidate.run();
                        this.filter.matchingFluidStacks = null;
                        this.validFluids = null;
                    }
                });
            }
        };
    }

    public static SimpleRegistry.Provider<Block, BlockSpoutingBehaviour> createSpoutingHandler(BlockStatePredicate block, SpecialSpoutHandlerEvent.SpoutHandler handler) {
        BlockSpoutingBehaviour internalHandler = (world, pos, spout, availableFluid, simulate) -> {
            if (!block.test(world.m_8055_(pos))) {
                return 0;
            }
            return (int)handler.fillBlock(new BlockContainerJS(world, pos), FluidStackJS.of((Object)FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)availableFluid)), simulate);
        };
        return blockIn -> block.testBlock(blockIn) ? internalHandler : null;
    }
}

