/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lipoolroomsadditions.network;

import java.util.function.Supplier;
import net.mcreator.lipoolroomsadditions.LipoolroomsadditionsMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LipoolroomsadditionsModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LipoolroomsadditionsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handleData);
    }

    public static class SavedDataSyncMessage {
        private final int dataType;
        private final SavedData data;

        public SavedDataSyncMessage(int dataType, SavedData data) {
            this.dataType = dataType;
            this.data = data;
        }

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt);
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt);
                }
            }
            this.dataType = dataType;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handleData(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.m_7176_(new CompoundTag()));
                    } else {
                        WorldVariables.clientSide.read(message.data.m_7176_(new CompoundTag()));
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "lipoolroomsadditions_mapvars";
        boolean _syncDirty = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void markSyncDirty() {
            this.m_77762_();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "lipoolroomsadditions_worldvars";
        boolean _syncDirty = false;
        public double bedTimer = 0.0;
        public boolean bedTimerEnabled = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.bedTimer = nbt.m_128459_("bedTimer");
            this.bedTimerEnabled = nbt.m_128471_("bedTimerEnabled");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("bedTimer", this.bedTimer);
            nbt.m_128379_("bedTimerEnabled", this.bedTimerEnabled);
            return nbt;
        }

        public void markSyncDirty() {
            this.m_77762_();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)player2.m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)player2.m_9236_());
                if (mapdata != null) {
                    LipoolroomsadditionsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    LipoolroomsadditionsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            ServerPlayer player;
            WorldVariables worlddata;
            Player player2 = event.getEntity();
            if (player2 instanceof ServerPlayer && (worlddata = WorldVariables.get((LevelAccessor)(player = (ServerPlayer)player2).m_9236_())) != null) {
                LipoolroomsadditionsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.LevelTickEvent event) {
            Level level;
            if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
                if (worldVariables._syncDirty) {
                    LipoolroomsadditionsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level2).m_46472_()), (Object)new SavedDataSyncMessage(1, worldVariables));
                    worldVariables._syncDirty = false;
                }
                MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
                if (mapVariables._syncDirty) {
                    LipoolroomsadditionsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, mapVariables));
                    mapVariables._syncDirty = false;
                }
            }
        }
    }
}

