/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RailgunShotEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class RailgunItem
extends UpgradeableToolItem
implements ZoomHandler.IZoomTool,
IEItemInterfaces.IScrollwheel {
    float[] zoomSteps = new float[]{0.1f, 0.15625f, 0.2f, 0.25f, 0.3125f, 0.4f, 0.5f, 0.625f};

    public RailgunItem() {
        super(new Item.Properties().m_41487_(1), "RAILGUN");
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    @Override
    public int getSlotCount() {
        return 3;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 80, 32, "RAILGUN", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 100, 32, "RAILGUN", stack, true, level, getPlayer)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void recalculateUpgrades(ItemStack stack, Level w, Player player) {
        super.recalculateUpgrades(stack, w, player);
        IEnergyStorage energy = (IEnergyStorage)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
        if (energy.getEnergyStored() > RailgunItem.getMaxEnergyStored(stack)) {
            ItemNBTHelper.putInt(stack, "energy", RailgunItem.getMaxEnergyStored(stack));
        }
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        super.clearUpgrades(stack);
        IEnergyStorage energy = (IEnergyStorage)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
        if (energy.getEnergyStored() > RailgunItem.getMaxEnergyStored(stack)) {
            ItemNBTHelper.putInt(stack, "energy", RailgunItem.getMaxEnergyStored(stack));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        Optional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return wrapperNew.map(w -> ItemStack.m_41728_((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse(true);
        });
        if (!sameShader.orElse(true).booleanValue()) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new IEItemStackHandler(stack){
                final LazyOptional<EnergyHelper.ItemEnergyStorage> energyStorage;
                final LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.energyStorage = CapabilityUtils.constantOptional(new EnergyHelper.ItemEnergyStorage(stack, RailgunItem::getMaxEnergyStored));
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "railgun"), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == ForgeCapabilities.ENERGY) {
                        return this.energyStorage.cast();
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        IEnergyStorage energy = (IEnergyStorage)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
        String stored = energy.getEnergyStored() + "/" + RailgunItem.getMaxEnergyStored(stack);
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}).m_130940_(ChatFormatting.GRAY));
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int consumption = (Integer)IEServerConfig.TOOLS.railgun_consumption.get();
        float energyMod = 1.0f + this.getUpgrades(stack).m_128457_("consumption");
        consumption = (int)((float)consumption * energyMod);
        IEnergyStorage energy = (IEnergyStorage)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
        if (energy.extractEnergy(consumption, true) == consumption && !RailgunItem.findAmmo(stack, player).m_41619_()) {
            player.m_6672_(hand);
            RailgunItem.playChargeSound((LivingEntity)player, stack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public static void playChargeSound(LivingEntity living, ItemStack railgun) {
        living.m_9236_().m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), RailgunItem.getChargeTime(railgun) <= 20 ? (SoundEvent)IESounds.chargeFast.get() : (SoundEvent)IESounds.chargeSlow.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int count) {
        int inUse = this.m_8105_(stack) - count;
        if (inUse > RailgunItem.getChargeTime(stack) && inUse % 20 == user.m_217043_().m_188503_(20)) {
            user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), (SoundEvent)IESounds.spark.get(), SoundSource.PLAYERS, 0.8f + 0.2f * user.m_217043_().m_188501_(), 0.5f + 0.5f * user.m_217043_().m_188501_());
            ShaderRegistry.ShaderAndCase shader = ShaderRegistry.getStoredShaderAndCase(stack);
            if (shader != null) {
                Vec3 pos = Utils.getLivingFrontPos(user, 0.4375, (double)user.m_20206_() * 0.75, ItemUtils.getLivingHand(user, user.m_7655_()), false, 1.0f);
                shader.registryEntry().getEffectFunction().execute(user.m_9236_(), shader.shader(), stack, shader.sCase().getShaderType().toString(), pos, null, 0.0625f);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int timeLeft) {
        if (!world.m_5776_() && user instanceof Player) {
            ItemStack ammo;
            Player player = (Player)user;
            int inUse = this.m_8105_(stack) - timeLeft;
            ItemNBTHelper.remove(stack, "inUse");
            if (inUse < RailgunItem.getChargeTime(stack)) {
                return;
            }
            int consumption = (Integer)IEServerConfig.TOOLS.railgun_consumption.get();
            float energyMod = 1.0f + this.getUpgrades(stack).m_128457_("consumption");
            consumption = (int)((float)consumption * energyMod);
            IEnergyStorage energy = (IEnergyStorage)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
            if (energy.extractEnergy(consumption, true) == consumption && !(ammo = RailgunItem.findAmmo(stack, player)).m_41619_()) {
                ItemStack ammoConsumed = ammo.m_41620_(1);
                RailgunItem.fireProjectile(stack, world, user, ammoConsumed);
                energy.extractEnergy(consumption, false);
            }
        }
    }

    public static Entity fireProjectile(ItemStack railgun, Level world, LivingEntity user, ItemStack ammo) {
        ShaderRegistry.ShaderAndCase shader;
        Player player;
        RailgunHandler.IRailgunProjectile projectileProperties = RailgunHandler.getProjectile(ammo);
        float speed = 20.0f;
        RailgunShotEntity shot = new RailgunShotEntity(user.m_9236_(), user, speed, 0.0f, ammo);
        shot = projectileProperties.getProjectile(user instanceof Player ? (player = (Player)user) : null, ammo, (Entity)shot);
        user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), (SoundEvent)IESounds.railgunFire.get(), SoundSource.PLAYERS, 1.0f, 0.5f + 0.5f * user.m_217043_().m_188501_());
        if (!world.f_46443_) {
            user.m_9236_().m_7967_((Entity)shot);
        }
        if ((shader = ShaderRegistry.getStoredShaderAndCase(railgun)) != null) {
            HumanoidArm handside = user.m_5737_();
            if (user.m_7655_() != InteractionHand.MAIN_HAND) {
                handside = handside == HumanoidArm.LEFT ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
            }
            Vec3 pos = Utils.getLivingFrontPos(user, 0.75, (double)user.m_20206_() * 0.75, handside, false, 1.0f);
            shader.registryEntry().getEffectFunction().execute(world, shader.shader(), railgun, shader.sCase().getShaderType().toString(), pos, Vec3.m_82503_((Vec2)user.m_20155_()), 0.125f);
        }
        return shot;
    }

    public static ItemStack findAmmo(ItemStack railgun, Player player) {
        int slot;
        ItemStack ammo;
        if (ItemNBTHelper.hasKey(railgun, "ammo_slot") && !(ammo = RailgunItem.findAmmoInSlot(player, slot = ItemNBTHelper.getInt(railgun, "ammo_slot"))).m_41619_()) {
            return ammo;
        }
        if (RailgunItem.isAmmo(player.m_21120_(InteractionHand.OFF_HAND))) {
            ItemNBTHelper.putInt(railgun, "ammo_slot", 0);
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (RailgunItem.isAmmo(player.m_21120_(InteractionHand.MAIN_HAND))) {
            ItemNBTHelper.putInt(railgun, "ammo_slot", 1);
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!RailgunItem.isAmmo(itemstack)) continue;
            ItemNBTHelper.putInt(railgun, "ammo_slot", 2 + i);
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack findAmmoInSlot(Player player, int slot) {
        ItemStack ammo = ItemStack.f_41583_;
        if (slot == 0 || slot == 1) {
            ammo = player.m_21120_(slot == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        } else if (slot > 1 && slot - 2 < player.m_150109_().m_6643_()) {
            ammo = player.m_150109_().m_8020_(slot - 2);
        }
        if (RailgunItem.isAmmo(ammo)) {
            return ammo;
        }
        return ItemStack.f_41583_;
    }

    public static boolean isAmmo(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        RailgunHandler.IRailgunProjectile prop = RailgunHandler.getProjectile(stack);
        return prop != null;
    }

    private boolean checkAmmoSlot(ItemStack stack, Player player, int actualSlot) {
        if (!RailgunItem.findAmmoInSlot(player, actualSlot).m_41619_()) {
            ItemNBTHelper.putInt(stack, "ammo_slot", actualSlot);
            player.m_150109_().m_6596_();
            return true;
        }
        return false;
    }

    @Override
    public void onScrollwheel(ItemStack stack, Player player, boolean forward) {
        int slot = ItemNBTHelper.getInt(stack, "ammo_slot");
        int count = player.m_150109_().m_6643_() + 2;
        if (forward) {
            for (int i = 1; i < count; ++i) {
                if (!this.checkAmmoSlot(stack, player, (slot + i) % count)) continue;
                return;
            }
        } else {
            for (int i = count - 1; i >= 1; --i) {
                if (!this.checkAmmoSlot(stack, player, (slot + i) % count)) continue;
                return;
            }
        }
    }

    public static int getChargeTime(ItemStack railgun) {
        return (int)(40.0f / (1.0f + RailgunItem.getUpgradesStatic(railgun).m_128457_("speed")));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        LazyOptional invCap = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        invCap.ifPresent(inv -> {
            if (!inv.getStackInSlot(0).m_41619_() && !inv.getStackInSlot(1).m_41619_()) {
                Utils.unlockIEAdvancement(player, "tools/upgrade_railgun");
            }
        });
    }

    public static int getMaxEnergyStored(ItemStack container) {
        return 8000;
    }

    @Override
    public boolean canZoom(ItemStack stack, Player player) {
        return this.getUpgrades(stack).m_128471_("scope");
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, Player player) {
        return this.zoomSteps;
    }
}

