/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.teamremastered.endrem.EndRemastered;
import com.teamremastered.endrem.config.ERConfigGenericEntry;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ERConfig {
    private static final ForgeConfigSpec.Builder CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    public static ERConfigGenericEntry<Boolean> THROW_ENDER_EYE;
    public static ERConfigGenericEntry<Boolean> USE_ENDER_EYE;
    public static ERConfigGenericEntry<Boolean> FRAME_HAS_EYE;
    public static ERConfigGenericEntry<Integer> EYE_BREAK_CHANCE;
    public static ERConfigGenericEntry<Boolean> CAN_REMOVE_EYE;
    public static ERConfigGenericEntry<Boolean> IS_CRYPTIC_EYE_OBTAINABLE;
    public static ERConfigGenericEntry<Boolean> IS_EVIL_EYE_OBTAINABLE;

    private static void init() {
        CONFIG.push("endrem");
        for (ERConfigGenericEntry<?> ccv : ERConfigGenericEntry.erConfigGenericEntries) {
            ccv.setup(CONFIG);
        }
        CONFIG.pop();
        COMMON_CONFIG = CONFIG.build();
    }

    public static void load() {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve(EndRemastered.CONFIG_FILE)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    static {
        THROW_ENDER_EYE = new ERConfigGenericEntry<Boolean>("throw_ender_eye", "Toggle Ender Eyes Actions (Throwing to Locate The Stronghold)", false);
        USE_ENDER_EYE = new ERConfigGenericEntry<Boolean>("use_ender_eye", "Toggle Ender Eyes Actions (Placing in Portal Frames)", false);
        FRAME_HAS_EYE = new ERConfigGenericEntry<Boolean>("frame_has_eye", "Determines whether or not vanilla eyes can naturally generate within the frames of the portal", false);
        EYE_BREAK_CHANCE = new ERConfigGenericEntry<Integer>("eye_break_chance", "Determines the percentage chance of eyes breaking when thrown", 10);
        CAN_REMOVE_EYE = new ERConfigGenericEntry<Boolean>("can_remove_eye", "Determines whether or not players can remove ender eyes from the portal frames", false);
        IS_CRYPTIC_EYE_OBTAINABLE = new ERConfigGenericEntry<Boolean>("is_cryptic_eye_obtainable", "Determines if it's possible to obtain the cryptic eye when enchanting", true);
        IS_EVIL_EYE_OBTAINABLE = new ERConfigGenericEntry<Boolean>("is_evil_eye_obtainable", "Determines if it's possible to obtain the evil eye when trading with a Cleric", true);
        ERConfig.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG, EndRemastered.CONFIG_FILE);
    }
}

