/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.Deserializers;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.GsonContextImpl;

public interface ContextualCondition {
    public static final Gson predicateGson = Deserializers.m_78798_().create();
    public static final GsonContextImpl gsonContext = new GsonContextImpl(predicateGson);

    public static void desc(List<Component> tooltips, InteractionResult result, int indent, MutableComponent content) {
        MutableComponent indentComponent = Component.m_237113_((String)"  ".repeat(indent));
        indentComponent.m_130946_(I18n.m_118938_((String)("result.lychee." + result.toString().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]));
        indentComponent.m_7220_((Component)content.m_130940_(ChatFormatting.GRAY));
        tooltips.add((Component)indentComponent);
    }

    public static ContextualCondition parse(JsonObject o) {
        ResourceLocation key = new ResourceLocation(o.get("type").getAsString());
        ContextualConditionType<?> type = LycheeRegistries.CONTEXTUAL.get(key);
        return type.fromJson(o);
    }

    public ContextualConditionType<? extends ContextualCondition> getType();

    public int test(ILycheeRecipe<?> var1, LycheeContext var2, int var3);

    public MutableComponent getDescription(boolean var1);

    default public String makeDescriptionId(boolean inverted) {
        Object key = CommonProxy.makeDescriptionId("contextual", this.getType().getRegistryName());
        if (inverted) {
            key = (String)key + ".not";
        }
        return key;
    }

    default public void appendTooltips(List<Component> tooltips, Level level, @Nullable Player player, int indent, boolean inverted) {
        ContextualCondition.desc(tooltips, this.testInTooltips(level, player), indent, this.getDescription(inverted));
    }

    default public InteractionResult testInTooltips(Level level, @Nullable Player player) {
        return InteractionResult.PASS;
    }

    default public JsonObject toJson() {
        JsonObject o = new JsonObject();
        o.addProperty("type", this.getType().getRegistryName().toString());
        this.getType().toJson(this, o);
        return o;
    }

    default public int showingCount() {
        return 1;
    }
}

