/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import snownee.lychee.util.json.JsonPointer;

public abstract class Reference {
    public static final Reference DEFAULT = new Constant("default");

    public static Reference create(String value) {
        if ("default".equals(value)) {
            return DEFAULT;
        }
        if (value.codePointAt(0) == 47) {
            return new Pointer(new JsonPointer(value));
        }
        return new Constant(value);
    }

    public static Reference fromJson(JsonObject parent, String key) {
        return Reference.create(GsonHelper.m_13851_((JsonObject)parent, (String)key, (String)"default"));
    }

    public static void toJson(Reference reference, JsonObject parent, String key) {
        if (reference == DEFAULT) {
            return;
        }
        parent.addProperty(key, reference.toString());
    }

    public static Reference fromNetwork(FriendlyByteBuf buf) {
        return Reference.create(buf.m_130277_());
    }

    public static void toNetwork(Reference reference, FriendlyByteBuf buf) {
        buf.m_130070_(reference.toString());
    }

    public boolean isPointer() {
        return this.getClass() == Pointer.class;
    }

    public JsonPointer getPointer() {
        return ((Pointer)this).pointer;
    }

    public static class Pointer
    extends Reference {
        private final JsonPointer pointer;

        public Pointer(JsonPointer pointer) {
            this.pointer = pointer;
        }

        public String toString() {
            return this.pointer.toString();
        }
    }

    public static class Constant
    extends Reference {
        public final String name;

        public Constant(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

