/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.createmod.ponder.render.VirtualRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.client.gui.FluidRenderer;
import snownee.lychee.client.gui.ILightingSettings;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.UIRenderHelper;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.Color;
import snownee.lychee.util.VecHelper;

public class GuiGameElement {
    public static GuiRenderBuilder of(ItemStack stack) {
        return new GuiItemRenderBuilder(stack);
    }

    public static GuiRenderBuilder of(ItemLike itemProvider) {
        return new GuiItemRenderBuilder(itemProvider);
    }

    public static GuiRenderBuilder of(BlockState state) {
        if (state.m_60799_() != RenderShape.MODEL && state.m_60819_().m_76178_()) {
            return GuiGameElement.of((ItemLike)state.m_60734_());
        }
        if (state.m_60734_() instanceof StairBlock) {
            state = (BlockState)state.m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122424_());
        }
        return new GuiBlockStateRenderBuilder(state);
    }

    public static GuiRenderBuilder of(Fluid fluid) {
        return new GuiBlockStateRenderBuilder((BlockState)fluid.m_76145_().m_76188_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(0)));
    }

    public static class GuiItemRenderBuilder
    extends GuiRenderBuilder {
        private final ItemStack stack;

        public GuiItemRenderBuilder(ItemStack stack) {
            this.stack = stack;
            this.scale = 10.0;
        }

        public GuiItemRenderBuilder(ItemLike provider) {
            this(provider.m_5456_().m_7968_());
        }

        @Override
        public void render(GuiGraphics graphics) {
            PoseStack matrixStack = graphics.m_280168_();
            this.prepareMatrix(matrixStack);
            this.transformMatrix(matrixStack);
            GuiItemRenderBuilder.renderItemIntoGUI(matrixStack, this.stack, this.customLighting == null);
            this.cleanUpMatrix(matrixStack);
        }

        @Override
        protected void transformMatrix(PoseStack matrixStack) {
            matrixStack.m_252880_(this.x, this.y, this.z);
            matrixStack.m_85837_(this.xLocal * this.scale, this.yLocal * this.scale, this.zLocal * this.scale);
            UIRenderHelper.flipForGuiRender(matrixStack);
        }

        public static void renderItemIntoGUI(PoseStack matrixStack, ItemStack stack, boolean useDefaultLighting) {
            boolean flatLighting;
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel bakedModel = renderer.m_174264_(stack, null, null, 0);
            Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.enableBlend();
            RenderSystem.enableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 0.0f, 100.0f);
            matrixStack.m_252880_(8.0f, -8.0f, 0.0f);
            matrixStack.m_85841_(16.0f, 16.0f, 16.0f);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = flatLighting = !bakedModel.m_7547_();
            if (useDefaultLighting && flatLighting) {
                Lighting.m_84930_();
            }
            renderer.m_115143_(stack, ItemDisplayContext.GUI, false, matrixStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
            RenderSystem.disableDepthTest();
            buffer.m_109911_();
            RenderSystem.enableDepthTest();
            if (useDefaultLighting && flatLighting) {
                Lighting.m_84931_();
            }
            matrixStack.m_85849_();
        }

        @Override
        public GuiRenderBuilder lighting(ILightingSettings lighting) {
            return this;
        }
    }

    public static abstract class GuiRenderBuilder
    extends RenderElement {
        protected double xLocal;
        protected double yLocal;
        protected double zLocal;
        protected double xRot;
        protected double yRot;
        protected double zRot;
        protected double scale = 1.0;
        protected int color = 0xFFFFFF;
        protected Vec3 rotationOffset = Vec3.f_82478_;
        protected ILightingSettings customLighting = null;

        public GuiRenderBuilder atLocal(double x, double y, double z) {
            this.xLocal = x;
            this.yLocal = y;
            this.zLocal = z;
            return this;
        }

        public GuiRenderBuilder rotate(double xRot, double yRot, double zRot) {
            this.xRot = xRot;
            this.yRot = yRot;
            this.zRot = zRot;
            return this;
        }

        public GuiRenderBuilder rotateBlock(double xRot, double yRot, double zRot) {
            return this.rotate(xRot, yRot, zRot).withRotationOffset(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_));
        }

        public GuiRenderBuilder scale(double scale) {
            this.scale = scale;
            return this;
        }

        public GuiRenderBuilder color(int color) {
            this.color = color;
            return this;
        }

        public GuiRenderBuilder withRotationOffset(Vec3 offset) {
            this.rotationOffset = offset;
            return this;
        }

        public GuiRenderBuilder lighting(ILightingSettings lighting) {
            this.customLighting = lighting;
            return this;
        }

        protected void prepareMatrix(PoseStack matrixStack) {
            matrixStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.prepareLighting(matrixStack);
        }

        protected void transformMatrix(PoseStack matrixStack) {
            matrixStack.m_252880_(this.x + 3.0f, this.y + 13.0f, this.z);
            matrixStack.m_85841_((float)this.scale, (float)this.scale, (float)this.scale);
            matrixStack.m_85837_(this.xLocal, this.yLocal, this.zLocal);
            UIRenderHelper.flipForGuiRender(matrixStack);
            matrixStack.m_85837_(this.rotationOffset.f_82479_, this.rotationOffset.f_82480_, this.rotationOffset.f_82481_);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_((float)this.zRot));
            matrixStack.m_252781_(Axis.f_252529_.m_252977_((float)this.xRot));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)this.yRot));
            matrixStack.m_85837_(-this.rotationOffset.f_82479_, -this.rotationOffset.f_82480_, -this.rotationOffset.f_82481_);
        }

        protected void cleanUpMatrix(PoseStack matrixStack) {
            matrixStack.m_85849_();
            this.cleanUpLighting(matrixStack);
        }

        protected void prepareLighting(PoseStack matrixStack) {
            if (this.customLighting != null) {
                this.customLighting.applyLighting();
            } else {
                Lighting.m_84931_();
            }
        }

        protected void cleanUpLighting(PoseStack matrixStack) {
            if (this.customLighting != null) {
                Lighting.m_84931_();
            }
        }
    }

    public static class GuiBlockStateRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockStateRenderBuilder(BlockState blockstate) {
            super(Minecraft.m_91087_().m_91289_().m_110910_(blockstate), blockstate);
        }

        @Override
        protected void renderModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, RenderType renderType, VertexConsumer vb, PoseStack ms) {
            if (this.blockState.m_60734_() instanceof FireBlock) {
                Lighting.m_84930_();
                blockRenderer.m_110912_(this.blockState, ms, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_);
                buffer.m_109911_();
                Lighting.m_84931_();
                return;
            }
            super.renderModel(blockRenderer, buffer, renderType, vb, ms);
            if (this.blockState.m_60819_().m_76178_()) {
                return;
            }
            float min = 0.001f;
            float max = 0.999f;
            FluidRenderer.renderFluidBox(this.blockState.m_60819_(), min, min, min, max, max * 0.8888889f, max, (MultiBufferSource)buffer, ms, 0xF000F0, false);
            buffer.m_109911_();
        }
    }

    private static class GuiBlockModelRenderBuilder
    extends GuiRenderBuilder {
        protected BakedModel blockModel;
        protected BlockState blockState;
        private ModelData modelData;

        public GuiBlockModelRenderBuilder(BakedModel blockmodel, @Nullable BlockState blockState) {
            this.blockState = blockState == null ? Blocks.f_50016_.m_49966_() : blockState;
            this.blockModel = blockmodel;
            this.modelData = ModelData.EMPTY;
            if (ClientProxy.HAS_FLYWHEEL) {
                this.modelData = VirtualRenderHelper.VIRTUAL_DATA;
            }
        }

        @Override
        public void render(GuiGraphics graphics) {
            PoseStack matrixStack = graphics.m_280168_();
            this.prepareMatrix(matrixStack);
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher blockRenderer = mc.m_91289_();
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            RenderType renderType = this.blockState.m_60734_() == Blocks.f_50016_ ? Sheets.m_110792_() : ItemBlockRenderTypes.m_109284_((BlockState)this.blockState, (boolean)true);
            VertexConsumer vb = buffer.m_6299_(renderType);
            this.transformMatrix(matrixStack);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            this.renderModel(blockRenderer, buffer, renderType, vb, matrixStack);
            this.cleanUpMatrix(matrixStack);
        }

        protected void renderModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, RenderType renderType, VertexConsumer vb, PoseStack ms) {
            Minecraft mc = Minecraft.m_91087_();
            int color = mc.m_91298_().m_92577_(this.blockState, (BlockAndTintGetter)mc.f_91073_, mc.f_91075_ != null ? mc.f_91075_.m_20183_() : null, 0);
            Color rgb = new Color(color == -1 ? this.color : color);
            blockRenderer.m_110937_().renderModel(ms.m_85850_(), vb, this.blockState, this.blockModel, rgb.getRedAsFloat(), rgb.getGreenAsFloat(), rgb.getBlueAsFloat(), 0xF000F0, OverlayTexture.f_118083_, this.modelData, null);
            buffer.m_109911_();
        }
    }
}

