/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.rightclickharvest;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.JamLibPlatform;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.rightclickharvest.Config;
import io.github.jamalam360.rightclickharvest.HarvestContext;
import io.github.jamalam360.rightclickharvest.HelloPacket;
import io.github.jamalam360.rightclickharvest.RightClickHarvestPlatform;
import io.github.jamalam360.rightclickharvest.ServerLangProvider;
import io.github.jamalam360.rightclickharvest.mixin.CropBlockAccessor;
import io.github.jamalam360.rightclickharvest.mixinsupport.ServerPlayerLanguageAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightClickHarvest {
    public static final String MOD_ID = "rightclickharvest";
    public static final String MOD_NAME = "Right Click Harvest";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Right Click Harvest");
    public static final ConfigManager<Config> CONFIG = new ConfigManager("rightclickharvest", Config.class);
    public static final TagKey<Block> BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)RightClickHarvest.id("blacklist"));
    public static final TagKey<Block> HOE_NEVER_REQUIRED = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)RightClickHarvest.id("hoe_never_required"));
    public static final TagKey<Block> RADIUS_HARVEST_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)RightClickHarvest.id("radius_harvest_blacklist"));
    public static final TagKey<Item> LOW_TIER_HOES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)RightClickHarvest.id("low_tier_hoes"));
    public static final TagKey<Item> MID_TIER_HOES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)RightClickHarvest.id("mid_tier_hoes"));
    public static final TagKey<Item> HIGH_TIER_HOES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)RightClickHarvest.id("high_tier_hoes"));
    public static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final IntProvider XP_PROVIDER = UniformInt.m_146622_((int)0, (int)2);
    private static final List<UUID> PLAYERS_WARNED_FOR_NOT_USING_HOE = new ArrayList<UUID>();

    public static void init() {
        LOGGER.info("Initializing Right Click Harvest on {}", (Object)JamLibPlatform.getPlatform().name());
        JamLib.checkForJarRenaming(RightClickHarvest.class);
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (NetworkManager.canPlayerReceive((ServerPlayer)player, (ResourceLocation)HelloPacket.TYPE)) {
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)HelloPacket.TYPE, (FriendlyByteBuf)HelloPacket.of());
            }
        });
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, hand, pos, face) -> {
            InteractionResult res = RightClickHarvest.onBlockUse(player, player.m_9236_(), hand, new BlockHitResult(player.m_20182_(), face, pos, false), true);
            return switch (res) {
                case InteractionResult.SUCCESS -> EventResult.interruptTrue();
                case InteractionResult.PASS -> EventResult.pass();
                case InteractionResult.FAIL -> EventResult.interruptFalse();
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(res));
            };
        });
    }

    @ApiStatus.Internal
    public static InteractionResult onBlockUse(Player player, Level level, InteractionHand hand, BlockHitResult hitResult, boolean initialCall) {
        if (player.m_5833_() || player.m_6047_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockState state = level.m_8055_(hitResult.m_82425_());
        ItemStack stackInHand = player.m_21120_(hand);
        boolean hoeInUse = false;
        if (state.m_204336_(BLACKLIST)) {
            return InteractionResult.PASS;
        }
        if (((Config)RightClickHarvest.CONFIG.get()).hungerLevel != Config.HungerLevel.NONE && !player.m_150110_().f_35937_ && player.m_36324_().m_38702_() <= 0) {
            return InteractionResult.PASS;
        }
        if (((Config)RightClickHarvest.CONFIG.get()).experienceType == Config.ExperienceType.COST && !player.m_150110_().f_35937_ && player.f_36078_ < XP_PROVIDER.m_142737_()) {
            return InteractionResult.PASS;
        }
        if (!state.m_204336_(HOE_NEVER_REQUIRED) && ((Config)RightClickHarvest.CONFIG.get()).requireHoe) {
            if (!RightClickHarvest.isHoe(stackInHand)) {
                RightClickHarvest.warnPlayerForNotUsingHoe(player, state, stackInHand);
                return InteractionResult.PASS;
            }
            hoeInUse = true;
        }
        if (!initialCall && state.m_204336_(RADIUS_HARVEST_BLACKLIST)) {
            return InteractionResult.PASS;
        }
        if (state.m_60734_() instanceof CocoaBlock || state.m_60734_() instanceof CropBlock || state.m_60734_() instanceof NetherWartBlock) {
            if (RightClickHarvest.isMature(state)) {
                if (initialCall && ((Config)RightClickHarvest.CONFIG.get()).harvestInRadius && !state.m_204336_(RADIUS_HARVEST_BLACKLIST) && RightClickHarvest.isHoe(stackInHand)) {
                    int radius = 0;
                    boolean circle = false;
                    hoeInUse = true;
                    if (stackInHand.m_204117_(HIGH_TIER_HOES)) {
                        radius = 2;
                        circle = true;
                    } else if (stackInHand.m_204117_(MID_TIER_HOES)) {
                        radius = 1;
                        circle = false;
                    } else if (stackInHand.m_204117_(LOW_TIER_HOES)) {
                        radius = 1;
                        circle = true;
                    }
                    if (radius == 1 && circle) {
                        for (Direction dir : CARDINAL_DIRECTIONS) {
                            RightClickHarvest.onBlockUse(player, level, hand, hitResult.m_82430_(hitResult.m_82425_().m_121945_(dir)), false);
                        }
                    } else if (radius > 0) {
                        for (int x = -radius; x <= radius; ++x) {
                            for (int z = -radius; z <= radius; ++z) {
                                if (x == 0 && z == 0) continue;
                                BlockPos pos = hitResult.m_82425_().m_5487_(Direction.Axis.X, x).m_5487_(Direction.Axis.Z, z);
                                if (circle && pos.m_123333_((Vec3i)hitResult.m_82425_()) > radius) continue;
                                RightClickHarvest.onBlockUse(player, level, hand, hitResult.m_82430_(pos), false);
                            }
                        }
                    }
                }
                return RightClickHarvest.completeHarvest(level, state, hitResult.m_82425_(), player, hand, stackInHand, hoeInUse, true, () -> level.m_46597_(hitResult.m_82425_(), RightClickHarvest.getReplantState(state)));
            }
        } else if (state.m_60734_() instanceof SugarCaneBlock || state.m_60734_() instanceof CactusBlock) {
            if (hitResult.m_82434_() == Direction.UP && (stackInHand.m_41720_() == Items.f_41909_ && state.m_60734_() instanceof SugarCaneBlock || stackInHand.m_41720_() == Items.f_41982_ && state.m_60734_() instanceof CactusBlock)) {
                return InteractionResult.PASS;
            }
            Block lookingFor = state.m_60734_() instanceof SugarCaneBlock ? Blocks.f_50130_ : Blocks.f_50128_;
            BlockPos bottom = hitResult.m_82425_();
            while (level.m_8055_(bottom.m_7495_()).m_60713_(lookingFor)) {
                bottom = bottom.m_7495_();
            }
            if (!level.m_8055_(bottom.m_7494_()).m_60713_(lookingFor)) {
                return InteractionResult.PASS;
            }
            BlockPos breakPos = bottom.m_6630_(1);
            return RightClickHarvest.completeHarvest(level, state, breakPos, player, hand, stackInHand, hoeInUse, false, () -> level.m_7471_(breakPos, false));
        }
        return InteractionResult.PASS;
    }

    private static void warnPlayerForNotUsingHoe(Player player, BlockState state, ItemStack stackInHand) {
        ServerPlayer serverPlayer;
        if (!RightClickHarvest.isHarvestable(state) || !stackInHand.m_41619_()) {
            return;
        }
        if (player.m_9236_().f_46443_) {
            if (!((Config)RightClickHarvest.CONFIG.get()).hasUserBeenWarnedForNotUsingHoe) {
                player.m_5661_((Component)Component.m_237110_((String)"text.rightclickharvest.use_a_hoe_warning", (Object[])new Object[]{Component.m_237115_((String)"config.rightclickharvest.requireHoe").m_130938_(s -> s.m_131140_(ChatFormatting.GREEN)), Component.m_237113_((String)"false").m_130938_(s -> s.m_131140_(ChatFormatting.GREEN))}), false);
                ((Config)RightClickHarvest.CONFIG.get()).hasUserBeenWarnedForNotUsingHoe = true;
                CONFIG.save();
            }
        } else if (player instanceof ServerPlayer && !NetworkManager.canPlayerReceive((ServerPlayer)(serverPlayer = (ServerPlayer)player), (ResourceLocation)HelloPacket.TYPE) && !PLAYERS_WARNED_FOR_NOT_USING_HOE.contains(player.m_20148_())) {
            String playerLang = ((ServerPlayerLanguageAccessor)serverPlayer).rightclickharvest$getLanguage();
            player.m_5661_((Component)Component.m_237110_((String)ServerLangProvider.getUseHoeMessageByLanguage(playerLang), (Object[])new Object[]{Component.m_237113_((String)ServerLangProvider.getRequireHoeConfigByLanguage(playerLang)).m_130938_(s -> s.m_131140_(ChatFormatting.GREEN)), Component.m_237113_((String)"false").m_130938_(s -> s.m_131140_(ChatFormatting.GREEN))}), false);
            PLAYERS_WARNED_FOR_NOT_USING_HOE.add(player.m_20148_());
        }
    }

    private static InteractionResult completeHarvest(Level level, BlockState state, BlockPos pos, Player player, InteractionHand hand, ItemStack stackInHand, boolean hoeInUse, boolean removeReplant, Runnable setBlockAction) {
        if (!level.f_46443_) {
            Block originalBlock = state.m_60734_();
            if (RightClickHarvestPlatform.postBreakEvent(level, pos, state, player)) {
                return InteractionResult.FAIL;
            }
            if (RightClickHarvestPlatform.postPlaceEvent(level, pos, player)) {
                return InteractionResult.FAIL;
            }
            RightClickHarvest.dropStacks(state, (ServerLevel)level, pos, (Entity)player, player.m_21120_(hand), removeReplant);
            setBlockAction.run();
            if (hoeInUse) {
                stackInHand.m_41622_(1, (LivingEntity)player, p -> {});
            }
            player.m_36399_(0.008f * ((Config)RightClickHarvest.CONFIG.get()).hungerLevel.modifier);
            int xp = switch (((Config)RightClickHarvest.CONFIG.get()).experienceType) {
                default -> throw new IncompatibleClassChangeError();
                case Config.ExperienceType.COST -> -XP_PROVIDER.m_214085_(player.m_217043_());
                case Config.ExperienceType.REWARD -> XP_PROVIDER.m_214085_(player.m_217043_());
                case Config.ExperienceType.NONE -> 0;
            };
            player.m_6756_(xp);
            RightClickHarvestPlatform.postAfterHarvestEvent(new HarvestContext(player, originalBlock));
        } else {
            player.m_5496_(state.m_60734_() instanceof NetherWartBlock ? SoundEvents.f_12114_ : SoundEvents.f_11839_, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean isHarvestable(BlockState state) {
        if (state.m_60734_() instanceof CocoaBlock || state.m_60734_() instanceof CropBlock || state.m_60734_() instanceof NetherWartBlock) {
            return RightClickHarvest.isMature(state);
        }
        return state.m_60734_() instanceof SugarCaneBlock || state.m_60734_() instanceof CactusBlock;
    }

    private static boolean isHoe(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_271298_) || stack.m_204117_(LOW_TIER_HOES) || stack.m_204117_(MID_TIER_HOES) || stack.m_204117_(HIGH_TIER_HOES) || RightClickHarvestPlatform.isHoeAccordingToPlatform(stack);
    }

    private static boolean isMature(BlockState state) {
        if (state.m_60734_() instanceof CocoaBlock) {
            return (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) >= 2;
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_52307_(state);
        }
        if (state.m_60734_() instanceof NetherWartBlock) {
            return (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) >= 3;
        }
        return false;
    }

    private static BlockState getReplantState(BlockState state) {
        if (state.m_60734_() instanceof CocoaBlock) {
            return (BlockState)state.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(0));
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return (BlockState)state.m_61124_((Property)((CropBlockAccessor)cropBlock).invokeM_7959_(), (Comparable)Integer.valueOf(0));
        }
        if (state.m_60734_() instanceof NetherWartBlock) {
            return (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    private static void dropStacks(BlockState state, ServerLevel world, BlockPos pos, Entity entity, ItemStack toolStack, boolean removeReplant) {
        Item replant = state.m_60734_().m_7397_((BlockGetter)world, pos, state).m_41720_();
        boolean[] removedReplant = new boolean[]{!removeReplant};
        Block.m_49874_((BlockState)state, (ServerLevel)world, (BlockPos)pos, null, (Entity)entity, (ItemStack)toolStack).forEach(stack -> {
            if (!removedReplant[0] && stack.m_41720_() == replant) {
                stack.m_41764_(stack.m_41613_() - 1);
                removedReplant[0] = true;
            }
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
        });
        state.m_222967_(world, pos, toolStack, true);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

